/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hitodaibutsu;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hitodaibutsu.ImpactBlastProjectile;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class ImpactBlastAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "impact_blast", new Pair[]{ImmutablePair.of((Object)"Launches a golden shock wave forward when punching an enemy or the air, hurting every entity in its path.", null)});
    private static final int COOLDOWN = 120;
    public static final AbilityCore<ImpactBlastAbility> INSTANCE = new AbilityCore.Builder<ImpactBlastAbility>("Impact Blast", AbilityCategory.DEVIL_FRUITS, ImpactBlastAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(SourceType.FIST).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.DAIBUTSU.get(), new MorphInfo[0]);

    public ImpactBlastAbility(AbilityCore<ImpactBlastAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.projectileComponent, this.requireMorphComponent);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
    }

    private ImpactBlastProjectile createProjectile(LivingEntity entity) {
        ImpactBlastProjectile proj = new ImpactBlastProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.projectileComponent.shoot(entity, 2.0f, 0.0f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    @Override
    public float getPunchCooldown() {
        return 120.0f;
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.projectileComponent.shoot(entity, 2.0f, 0.0f);
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }
}

