/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.horu.WinkExplosionEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DeathWinkAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "death_wink", new Pair[]{ImmutablePair.of((Object)"The user winks really hard creating a shockwave; Ganmen Seicho boosts it's power.", null)});
    private static final int COOLDOWN = 120;
    public static final AbilityCore<DeathWinkAbility> INSTANCE = new AbilityCore.Builder<DeathWinkAbility>("Death Wink", AbilityCategory.DEVIL_FRUITS, DeathWinkAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();

    public DeathWinkAbility(AbilityCore<DeathWinkAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        Entity e;
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DEATH_WINK_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, 1.0);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HORU_WINK.get(), (Entity)entity, trace.func_216347_e().func_82615_a(), entity.func_226278_cu_(), trace.func_216347_e().func_82616_c());
        int power = entity.func_70644_a((Effect)ModEffects.GANMEN_SEICHO_HORMONE.get()) ? 3 : 2;
        boolean createExplosion = true;
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 8 * power);
        double x = mop.func_216347_e().field_72450_a;
        double y = mop.func_216347_e().field_72448_b;
        double z = mop.func_216347_e().field_72449_c;
        if (mop instanceof EntityRayTraceResult && (e = ((EntityRayTraceResult)mop).func_216348_a()) instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)e).getDamage() < (float)(power * 5)) {
            createExplosion = false;
            AbilityHelper.setDeltaMovement(e, -e.func_213322_ci().field_72450_a, e.func_213322_ci().field_72448_b, -e.func_213322_ci().field_72450_a);
        }
        if (createExplosion) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, x, y, z, 1 + power);
            explosion.setStaticDamage(power * 10);
            explosion.setExplosionSound(false);
            explosion.setSmokeParticles(new WinkExplosionEffect(2));
            explosion.doExplosion();
            double distance = Math.sqrt(entity.func_70092_e(x, y, z));
            if (distance < 0.5) {
                AbilityHelper.setDeltaMovement((Entity)entity, WyHelper.randomWithRange(-1, 1) * 0.5 * (double)power, 1.5 * (double)power, WyHelper.randomWithRange(-1, 1) * 0.5 * (double)power);
            }
        }
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }
}

