/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horu;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class OnnaHormoneAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "onna_hormone", new Pair[]{ImmutablePair.of((Object)"By injecting an enemy with special hormones, the user can inflict moderate debuffs on their enemies", null), ImmutablePair.of((Object)"\u00a7aSHIFT-USE\u00a7r: User injects themselves", null)});
    private static final int COOLDOWN = 400;
    public static final AbilityCore<OnnaHormoneAbility> INSTANCE = new AbilityCore.Builder<OnnaHormoneAbility>("Onna Hormone", AbilityCategory.DEVIL_FRUITS, OnnaHormoneAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ContinuousComponent.getTooltip()).build();

    public OnnaHormoneAbility(AbilityCore<OnnaHormoneAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_213453_ef()) {
            entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 300, 2));
            entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1));
            entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 300, 0));
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        target.func_195064_c(new EffectInstance(Effects.field_76431_k, 300, 2));
        target.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1));
        target.func_195064_c(new EffectInstance(Effects.field_76424_c, 300, 0));
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 400.0f;
    }
}

