/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;

public class BlackKnightAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "black_knight", new Pair[]{ImmutablePair.of((Object)"Creates a clone of the user made entirely out of compressed strings", null)});
    private static final int HOLD_TIME = 20000;
    private static final int MIN_COOLDOWN = 40;
    private static final int MAX_COOLDOWN = 6000;
    public static final AbilityCore<BlackKnightAbility> INSTANCE = new AbilityCore.Builder<BlackKnightAbility>("Black Knight", AbilityCategory.DEVIL_FRUITS, BlackKnightAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 6000.0f), ContinuousComponent.getTooltip()).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::onTickEvent).addEndEvent(100, this::stopContinuityEvent);
    private BlackKnightEntity blackKnight = null;

    public BlackKnightAbility(AbilityCore<BlackKnightAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.blackKnight = new BlackKnightEntity(entity.field_70170_p, entity);
        this.blackKnight.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            this.blackKnight.func_184201_a(slot, stack);
        }
        entity.field_70170_p.func_217376_c((Entity)this.blackKnight);
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        if (this.blackKnight == null || !this.blackKnight.func_70089_S()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.blackKnight != null) {
            this.blackKnight.func_70106_y();
        }
        float cooldown = MathHelper.func_76131_a((float)this.continuousComponent.getContinueTime(), (float)40.0f, (float)6000.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    @Nullable
    public BlackKnightEntity getBlackKnight() {
        return this.blackKnight;
    }
}

