/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KumoNoSugakiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kumo_no_sugaki", new Pair[]{ImmutablePair.of((Object)"Creates a huge web that protects the user from any attack", null)});
    private static final int HOLD_TIME = 120;
    private static final int MIN_COOLDOWN = 20;
    private static final int MAX_COOLDOWN = 140;
    public static final AbilityCore<KumoNoSugakiAbility> INSTANCE = new AbilityCore.Builder<KumoNoSugakiAbility>("Kumo no Sugaki", AbilityCategory.DEVIL_FRUITS, KumoNoSugakiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 140.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuousEvent).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);

    public KumoNoSugakiAbility(AbilityCore<KumoNoSugakiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.animationComponent, this.poolComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 120.0f);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.5);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 5, false, false));
        AbilityHelper.slowEntityFall(entity);
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KUMO_NO_SUGAKI.get(), (Entity)entity, entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_() + 0.25 + look.field_72448_b, entity.func_226281_cx_() + look.field_72449_c);
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 20.0f + this.continuousComponent.getContinueTime());
    }
}

