/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ito.TamaitoProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class TamaitoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tamaito", new Pair[]{ImmutablePair.of((Object)"The user shoots a small bundle of strings, acting like a bullet", null)});
    private static final float COOLDOWN = 30.0f;
    public static final AbilityCore<TamaitoAbility> INSTANCE = new AbilityCore.Builder<TamaitoAbility>("Tamaito", AbilityCategory.DEVIL_FRUITS, TamaitoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(30.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public TamaitoAbility(AbilityCore<TamaitoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 4.0f, 1.2f);
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 7);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        this.cooldownComponent.startCooldown(entity, 30.0f);
    }

    private TamaitoProjectile createProjectile(LivingEntity entity) {
        TamaitoProjectile proj = new TamaitoProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

