/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AttractAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "attract", new Pair[]{ImmutablePair.of((Object)"Attracts all nearby magnetic objects from the ground or enemy inventories.", null)});
    private static final int COOLDOWN = 60;
    private static final int HOLD_TIME = 100;
    private static final int RADIUS = 40;
    public static final AbilityCore<AttractAbility> INSTANCE = new AbilityCore.Builder<AttractAbility>("Attract", AbilityCategory.DEVIL_FRUITS, AttractAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f), ContinuousComponent.getTooltip(100.0f), RangeComponent.getTooltip(40.0f, RangeComponent.RangeType.AOE)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);

    public AttractAbility(AbilityCore<AttractAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        List<Entity> targets = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 40.0, ModEntityPredicates.getEnemyFactions(entity), MobEntity.class, PlayerEntity.class);
        List items = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 40.0, null, ItemEntity.class);
        targets.addAll(items);
        for (Entity target : targets) {
            if (target instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)target;
                if (item.func_92059_d().func_190926_b() || !item.func_92059_d().func_77973_b().func_206844_a(ModTags.Items.MAGNETIC) || EnchantmentHelper.func_82781_a((ItemStack)item.func_92059_d()).containsKey(ModEnchantments.KAIROSEKI.get()) || item.func_92059_d().func_77942_o() && item.func_92059_d().func_77978_p().func_74764_b("imbuingHakiActive")) continue;
                Vector3d vec = item.func_213303_ch().func_178788_d(entity.func_213303_ch().func_72441_c(0.0, 1.5, 0.0)).func_216372_d(1.2, 1.2, 1.2);
                double speedReduction = 8.0;
                double xSpeed = -vec.field_72450_a / speedReduction;
                double ySpeed = -vec.field_72448_b / speedReduction;
                double zSpeed = -vec.field_72449_c / speedReduction;
                AbilityHelper.setDeltaMovement((Entity)item, xSpeed, ySpeed, zSpeed);
                double dist = Math.sqrt(entity.func_233580_cy_().func_177951_i((Vector3i)item.func_233580_cy_()));
                if (dist > 3.0) {
                    int delay = (int)Math.max(5.0, dist / 3.0);
                    item.func_174867_a(delay);
                }
                if (this.continuousComponent.getContinueTime() % 40.0f != 0.0f) continue;
                JikiHelper.spawnAttractEffect((Entity)item);
                continue;
            }
            Iterable iter = target.func_184209_aF();
            if (target instanceof PlayerEntity) {
                PlayerInventory playerInv = ((PlayerEntity)target).field_71071_by;
                iter = Iterables.concat((Iterable)playerInv.field_70462_a, (Iterable)playerInv.field_70460_b, (Iterable)playerInv.field_184439_c);
            }
            for (ItemStack stack : iter) {
                if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(ModTags.Items.MAGNETIC) || EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(ModEnchantments.KAIROSEKI.get()) || stack.func_77942_o() && stack.func_77978_p().func_74764_b("imbuingHakiActive")) continue;
                if (target instanceof MobEntity) {
                    for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
                        if (!((MobEntity)target).func_184582_a(slotType).equals(stack)) continue;
                        ((MobEntity)target).func_184201_a(slotType, ItemStack.field_190927_a);
                    }
                }
                if (HakiHelper.hasImbuingActive((LivingEntity)target, false, true)) continue;
                ItemEntity item = target.func_70099_a(stack.func_77946_l(), 1.0f);
                if (item != null) {
                    item.func_174867_a(30);
                }
                stack.func_190918_g(stack.func_190916_E());
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }
}

