/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSyncAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class MagneticItemsAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "magnetic_items", new Pair[]{ImmutablePair.of((Object)"Displays the total value of maginetic items in the user's inventory", null)});
    private static final DecimalFormat FORMAT = new DecimalFormat("#0.0");
    private float ironValue;
    private float prevIronValue = -1.0f;
    public static final AbilityCore<MagneticItemsAbility> INSTANCE = new AbilityCore.Builder<MagneticItemsAbility>("Magnetic Items", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, MagneticItemsAbility::new).addDescriptionLine(DESCRIPTION).build();

    public MagneticItemsAbility(AbilityCore<MagneticItemsAbility> core) {
        super(core);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent(this, this::renderGauge);
            super.addComponents(gaugeComponent);
        }
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    public void duringPassiveEvent(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
            this.ironValue = JikiHelper.getIronAmount(inventory);
            if (this.ironValue != this.prevIronValue) {
                if (entity instanceof PlayerEntity) {
                    WyNetwork.sendTo(new SSyncAbilityPacket(entity.func_145782_y(), this), (PlayerEntity)entity);
                }
                this.prevIronValue = this.ironValue;
            }
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74776_a("ironValue", this.ironValue);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.ironValue = nbt.func_74760_g("ironValue");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, MagneticItemsAbility ability) {
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        RendererHelper.drawAbilityIcon(INSTANCE, matrixStack, posX, posY - 38, 0, 32.0f, 32.0f);
        String value = FORMAT.format(ability.ironValue);
        WyHelper.drawStringWithBorder(mc.field_71466_p, matrixStack, value, posX + 16 - mc.field_71466_p.func_78256_a(value) / 2, posY - 15, Color.WHITE.getRGB());
        RenderSystem.disableBlend();
    }
}

