/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class KageGiriAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kage_giri", new Pair[]{ImmutablePair.of((Object)"Allows the user to cut an enemy's shadow using a pair of Scissors", null)});
    public static final AbilityCore<KageGiriAbility> INSTANCE = new AbilityCore.Builder<KageGiriAbility>("Kage Giri", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, KageGiriAbility::new).addDescriptionLine(DESCRIPTION).build();
    private Map<UUID, Long> shadowsList = new HashMap<UUID, Long>();

    public KageGiriAbility(AbilityCore<KageGiriAbility> ability) {
        super(ability);
    }

    public boolean addIfValid(UUID id) {
        if (this.shadowsList.containsKey(id)) {
            if (this.canTakeShadow(this.shadowsList.get(id))) {
                this.shadowsList.remove(id);
                return true;
            }
            return false;
        }
        this.shadowsList.put(id, System.currentTimeMillis());
        return true;
    }

    public boolean canTakeShadow(long t) {
        return System.currentTimeMillis() - t >= 600000L;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        ListNBT shadows = new ListNBT();
        for (Map.Entry<UUID, Long> entry : this.shadowsList.entrySet()) {
            if (this.canTakeShadow(entry.getValue())) continue;
            CompoundNBT entryNbt = new CompoundNBT();
            entryNbt.func_186854_a("id", entry.getKey());
            entryNbt.func_74772_a("time", entry.getValue().longValue());
            shadows.add((Object)entryNbt);
        }
        nbt.func_218657_a("shadows", (INBT)shadows);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        ListNBT shadows = nbt.func_150295_c("shadows", 10);
        this.shadowsList.clear();
        for (int i = 0; i < shadows.size(); ++i) {
            CompoundNBT entryNbt = shadows.func_150305_b(i);
            UUID id = entryNbt.func_186857_a("id");
            long time = entryNbt.func_74763_f("time");
            if (this.canTakeShadow(time)) continue;
            this.shadowsList.put(id, time);
        }
    }
}

