/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.kage.KageHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class KageKakumeiAbility
extends PunchAbility2 {
    private static final int SHADOWS_REQUIRED = 20;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kage_kakumei", new Pair[]{ImmutablePair.of((Object)"By hitting another entity the user impales \u00a7220\u00a7r shadows at once into them boosting their physical abilities", null)});
    private static final float COOLDOWN = 200.0f;
    public static final AbilityCore<KageKakumeiAbility> INSTANCE = new AbilityCore.Builder<KageKakumeiAbility>("Kage Kakumei", AbilityCategory.DEVIL_FRUITS, KageKakumeiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip()).build();

    public KageKakumeiAbility(AbilityCore<KageKakumeiAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.hitTriggerComponent.addTryHitEvent(80, this::hitEvent);
    }

    private HitTriggerComponent.HitResult hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.canActivate().test(entity)) {
            target.func_195064_c(new EffectInstance(Effects.field_76424_c, 400, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76429_m, 400, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 0));
            target.func_195064_c(new EffectInstance(Effects.field_180152_w, 400, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 0));
            KageHelper.removeShadows(entity, 20);
            return HitTriggerComponent.HitResult.FAIL;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        return true;
    }

    @Override
    public float getPunchCooldown() {
        return 200.0f;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && KageHelper.hasEnoughShadows(entity, this, 20).isSuccess();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }
}

