/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kira;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.kira.DiamondBodyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class BrilliantPunkAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "brilliant_punk", new Pair[]{ImmutablePair.of((Object)"The user rams into the target with their diamond body.", null)});
    private static final int HOLD_TIME = 10;
    private static final int COOLDOWN = 200;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 25.0f;
    public static final AbilityCore<BrilliantPunkAbility> INSTANCE = new AbilityCore.Builder<BrilliantPunkAbility>("Brilliant Punk", AbilityCategory.DEVIL_FRUITS, BrilliantPunkAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(25.0f)).setSourceType(SourceType.PHYSICAL).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);

    public BrilliantPunkAbility(AbilityCore<BrilliantPunkAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(this::requiresDiamondBody);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.TACKLE);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(2.3, 0.0, 2.3);
            entity.func_213315_a(MoverType.SELF, speed);
            List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.0f, 1.6f);
            for (LivingEntity livingEntity : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)livingEntity)) continue;
                this.dealDamageComponent.hurtTarget(entity, livingEntity, 25.0f);
            }
            for (Entity entity2 : this.hitTrackerComponent.getHits()) {
                entity2.func_70634_a(entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_(), entity.func_226281_cx_() + look.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private AbilityUseResult requiresDiamondBody(LivingEntity entity, IAbility ability) {
        boolean diamondBodyActive;
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        DiamondBodyAbility diamondBody = abilityProps.getEquippedAbility(DiamondBodyAbility.INSTANCE);
        boolean bl = diamondBodyActive = diamondBody != null && diamondBody.isContinuous();
        if (!diamondBodyActive) {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{this.getDisplayName().getString(), DiamondBodyAbility.INSTANCE.getUnlocalizedName()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }
}

