/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kuku;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GastronomorphAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gastronomorph", new Pair[]{ImmutablePair.of((Object)"Turns the surroundings into cake sponge blocks.", null)});
    private static final int CHARGE_TIME = 60;
    private static final int COOLDOWN = 300;
    private static final int RANGE = 32;
    public static final AbilityCore<GastronomorphAbility> INSTANCE = new AbilityCore.Builder<GastronomorphAbility>("Gastronomorph", AbilityCategory.DEVIL_FRUITS, GastronomorphAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ChargeComponent.getTooltip(60.0f), RangeComponent.getTooltip(32.0f, RangeComponent.RangeType.LINE)).build();
    public static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).build();
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);

    public GastronomorphAbility(AbilityCore<GastronomorphAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.blockPlacingHelper.clearList();
        double radiusXZ = 32.0;
        double radiusY = 9.0;
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (double y = -radiusY; y < radiusY; y += 1.0) {
            for (double x = -radiusXZ; x < radiusXZ; x += 1.0) {
                for (double z = -radiusXZ; z < radiusXZ; z += 1.0) {
                    double posZ;
                    double posY;
                    double posX = entity.func_226277_ct_() + x + (x < -WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) || x > WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    if (!AbilityHelper.canPlaceBlock(entity.field_70170_p, posX, posY = entity.func_226278_cu_() + y, posZ = entity.func_226281_cx_() + z + (z < -WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) || z > WyHelper.randomWithRange((int)(radiusXZ * 0.5), (int)(radiusXZ * 0.75)) ? WyHelper.randomWithRange(-5, 5) : 0.0), Blocks.field_205164_gk.func_176223_P(), 3, DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID)) continue;
                    mutpos.func_189532_c(posX, posY, posZ);
                    this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, (int)(x * x + y * y + z * z));
                }
            }
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        Set<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator<BlockPos> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            if (finished-- < 0) break;
            AbilityHelper.placeBlockIfAllowed(entity, blockPos, ((Block)ModBlocks.SPONGE_CAKE.get()).func_176223_P(), 3, DefaultProtectionRules.CORE_FOLIAGE_ORE);
            iterator.remove();
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

