/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mandemontactics;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class DemonicDashAbility
extends Ability {
    private static final int COOLDOWN = 160;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 30.0f;
    private static final int CHARGE_TIME = 20;
    public static final TargetsPredicate TARGET_TEST = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<DemonicDashAbility> INSTANCE = new AbilityCore.Builder<DemonicDashAbility>("Demonic Dash", AbilityCategory.STYLE, DemonicDashAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ChargeComponent.getTooltip(20.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(30.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.BLUNT).build();
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    @Nullable
    private LivingEntity target;

    public DemonicDashAbility(AbilityCore<DemonicDashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.continuousComponent, this.hitTrackerComponent, this.chargeComponent);
        this.addCanUseCheck(AbilityHelper::requiresTonfaWeapon);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.DEMONIC_DASH);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = this.target == null ? entity.func_70040_Z().func_216372_d(5.5, 0.0, 5.5) : entity.func_213303_ch().func_178788_d(this.target.func_213303_ch()).func_72432_b().func_216372_d(5.5, 2.5, 5.5);
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 0.15, speed.field_72449_c);
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.6f, 1.5f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 30.0f);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.target = null;
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    public void setTarget(LivingEntity entity) {
        this.target = entity;
    }
}

