/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.mera.MeraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.mera.HibashiraParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HibashiraAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "hibashira", new Pair[]{ImmutablePair.of((Object)"Creates a fire pillar extending both upwards and downwards, burning every enemy within it", null)});
    private static final int ON_HOLD = 100;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 250;
    private static final double PILLAR_SIZE = 3.5;
    private static final float DAMAGE = 5.0f;
    public static final AbilityCore<HibashiraAbility> INSTANCE = new AbilityCore.Builder<HibashiraAbility>("Hibashira", AbilityCategory.DEVIL_FRUITS, HibashiraAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 250.0f), ContinuousComponent.getTooltip(100.0f), DealDamageComponent.getTooltip(5.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final Interval particleInterval = new Interval(2);
    private final Interval clearHitsInterval = new Interval(20);

    public HibashiraAbility(AbilityCore<HibashiraAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.hitTrackerComponent, this.dealDamageComponent);
        super.addCanUseCheck(MeraHelper::canUseMeraAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.particleInterval.restartIntervalToZero();
        ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setUnavoidable();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HIBASHIRA.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), HibashiraParticleEffect.NO_DETAILS);
        }
        List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 3.5, 10.0, 3.5, ModEntityPredicates.getEnemyFactions(entity));
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 5.0f)) continue;
            target.func_70015_d(4);
        }
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
        AbilityHelper.slowEntityFall(entity);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        float cooldown = 200.0f + this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

