/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.mera.MeraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.HidarumaProjectile;

public class HidarumaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "hidaruma", new Pair[]{ImmutablePair.of((Object)"Creates small green fireballs that set the target on fire", null)});
    private static final int MAX_THRESHOLD = 60;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 500;
    private static final int MAX_FIREFLIES = 30;
    private final Interval fireflyInterval = new Interval(2);
    public static final AbilityCore<HidarumaAbility> INSTANCE = new AbilityCore.Builder<HidarumaAbility>("Hidaruma", AbilityCategory.DEVIL_FRUITS, HidarumaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 500.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public HidarumaAbility(AbilityCore<HidarumaAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.projectileComponent);
        super.addCanUseCheck(MeraHelper::canUseMeraAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity player, IAbility ability) {
        this.continuousComponent.triggerContinuity(player, 60.0f);
    }

    private void onContinuityTick(LivingEntity player, IAbility ability) {
        if (this.fireflyInterval.canTick()) {
            HidarumaProjectile proj = (HidarumaProjectile)((Object)this.projectileComponent.getNewProjectile(player));
            double offsetX = (this.random.nextDouble() - 0.5) * 0.2;
            double offsetY = (this.random.nextDouble() - 0.5) * 0.2;
            double offsetZ = (this.random.nextDouble() - 0.5) * 0.2;
            AbilityHelper.setDeltaMovement((Entity)proj, player.func_70040_Z().func_72432_b().func_186678_a(0.25).func_72441_c(offsetX, offsetY, offsetZ));
            player.field_70170_p.func_217376_c((Entity)proj);
        }
    }

    private void onContinuityEnd(LivingEntity player, IAbility ability) {
        this.fireflyInterval.restartIntervalToZero();
        this.cooldownComponent.startCooldown(player, 200.0f + this.continuousComponent.getContinueTime() * 5.0f);
    }

    private HidarumaProjectile createProjectile(LivingEntity entity) {
        HidarumaProjectile proj = new HidarumaProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

