/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.mera.MeraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KyokaenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kyokaen", new Pair[]{ImmutablePair.of((Object)"Creates a wall of fire protecting the user", null)});
    private static final float DAMAGE = 3.0f;
    private static final int ON_HOLD = 100;
    private static final int MIN_COOLDOWN = 40;
    private static final int MAX_COOLDOWN = 140;
    public static final AbilityCore<KyokaenAbility> INSTANCE = new AbilityCore.Builder<KyokaenAbility>("Kyokaen", AbilityCategory.DEVIL_FRUITS, KyokaenAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 140.0f), ContinuousComponent.getTooltip(100.0f), DealDamageComponent.getTooltip(3.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final Interval particleInterval = new Interval(2);
    private final Interval clearHitsInterval = new Interval(20);

    public KyokaenAbility(AbilityCore<KyokaenAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.hitTrackerComponent, this.dealDamageComponent);
        super.addCanUseCheck(MeraHelper::canUseMeraAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.particleInterval.restartIntervalToZero();
        this.hitTrackerComponent.clearHits();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        int range = 2;
        double boxSize = 1.1;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vector3d lookVec = entity.func_70040_Z();
            Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * distance, entity.func_226278_cu_() + (double)entity.func_70047_e() + lookVec.field_72448_b * distance, entity.func_226281_cx_() + lookVec.field_72449_c * distance);
            AxisAlignedBB aabb = new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize);
            List targets = entity.field_70170_p.func_175674_a((Entity)entity, aabb, target -> target != entity);
            for (Entity target2 : targets) {
                if (target2 instanceof LivingEntity) {
                    if (!target2.func_70027_ad() && this.hitTrackerComponent.canHit(target2)) {
                        AbilityHelper.setSecondsOnFireBy(target2, 3, entity);
                        this.dealDamageComponent.hurtTarget(entity, (LivingEntity)target2, 3.0f);
                    }
                    Vector3d dir = entity.func_70040_Z().func_72432_b().func_186678_a(3.0);
                    AbilityHelper.setDeltaMovement(target2, dir.field_72450_a, 0.5, dir.field_72449_c);
                    continue;
                }
                if (target2 instanceof AbstractArrowEntity || target2 instanceof KairosekiBulletProjectile || target2 instanceof NormalBulletProjectile) {
                    target2.func_70106_y();
                    continue;
                }
                if (!(target2 instanceof ThrowableEntity)) continue;
                AbilityHelper.setDeltaMovement(target2, target2.func_213322_ci().func_216372_d(-1.35, 1.0, -1.35));
            }
        }
        if (this.particleInterval.canTick()) {
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, range);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KYOKAEN.get(), (Entity)entity, trace.func_216347_e().func_82615_a(), entity.func_226278_cu_(), trace.func_216347_e().func_82616_c());
        }
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        float cooldown = 40.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

