/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mogu;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class MoguHeavyPointAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mogu_heavy_point", new Pair[]{ImmutablePair.of((Object)"Transforms the user into a mole, which focuses on strength and digging speed", null)});
    public static final AbilityCore<MoguHeavyPointAbility> INSTANCE = new AbilityCore.Builder<MoguHeavyPointAbility>("Mogu Heavy Point", AbilityCategory.DEVIL_FRUITS, MoguHeavyPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(10.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Mogu Heavy Point Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Mogu Heavy Point Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Mogu Heavy Point Modifier", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Mogu Heavy Reach Modifier", -0.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Mogu Heavy Point Toughness Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier MINING_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MINING_SPEED_UUID, INSTANCE, "Mogu Heavy Point Mining Speed Modifier", 5.0, AttributeModifier.Operation.ADDITION);

    public MoguHeavyPointAbility(AbilityCore<MoguHeavyPointAbility> core) {
        super(core);
        Predicate<LivingEntity> isContinuityActive = entity -> this.continuousComponent.isContinuous();
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.MINING_SPEED, (AttributeModifier)MINING_SPEED_MODIFIER, isContinuityActive);
        this.continuousComponent.addEndEvent(100, this::onEndContinuityEvent);
    }

    public void duringContinuityEvent(PlayerEntity player, int time) {
        player.func_195064_c(new EffectInstance(Effects.field_76422_e, 5, 2, false, false));
        if (!player.func_70644_a(Effects.field_76439_r) || player.func_70660_b(Effects.field_76439_r).func_76459_b() < 500) {
            player.func_195064_c(new EffectInstance(Effects.field_76439_r, 500, 0, false, false));
        }
    }

    protected void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195063_d(Effects.field_76424_c);
        entity.func_195063_d(Effects.field_76439_r);
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.MOGU_HEAVY.get();
    }
}

