/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class SmokeLaunchAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "smmoke_launch", new Pair[]{ImmutablePair.of((Object)"Launches all nearby entities surrounded by smoke in the sky.", null)});
    private static final int COOLDOWN = 300;
    private static final int RANGE = 100;
    public static final AbilityCore<SmokeLaunchAbility> INSTANCE = new AbilityCore.Builder<SmokeLaunchAbility>("Smoke Launch", AbilityCategory.DEVIL_FRUITS, SmokeLaunchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), RangeComponent.getTooltip(100.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public SmokeLaunchAbility(AbilityCore<SmokeLaunchAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    public void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 100.0f);
        for (LivingEntity target : targets) {
            if (!target.func_70644_a((Effect)ModEffects.SMOKE.get())) continue;
            target.func_195063_d((Effect)ModEffects.SMOKE.get());
            target.func_195064_c(new EffectInstance(Effects.field_188424_y, 200, 1));
        }
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

