/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.WhiteBlowProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class WhiteBlowAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "white_blow", new Pair[]{ImmutablePair.of((Object)"Shoots a cloud of smoke to engulf the opponent and trap them", null)});
    private static final int COOLDOWN = 100;
    public static final AbilityCore<WhiteBlowAbility> INSTANCE = new AbilityCore.Builder<WhiteBlowAbility>("White Blow", AbilityCategory.DEVIL_FRUITS, WhiteBlowAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.SMOKE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public WhiteBlowAbility(AbilityCore<WhiteBlowAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 7);
        this.projectileComponent.shoot(entity, 2.75f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private WhiteBlowProjectile createProjectile(LivingEntity entity) {
        WhiteBlowProjectile proj = new WhiteBlowProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

