/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class WhitePullAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "white_pull", new Pair[]{ImmutablePair.of((Object)"Pulls all nearby entities surrounded by smoke towards the user.", null)});
    private static final int COOLDOWN = 200;
    private static final int RANGE = 100;
    public static final AbilityCore<WhitePullAbility> INSTANCE = new AbilityCore.Builder<WhitePullAbility>("White Pull", AbilityCategory.DEVIL_FRUITS, WhitePullAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(100.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private ArrayList<LivingEntity> targetsToRemove = new ArrayList();

    public WhitePullAbility(AbilityCore<WhitePullAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    public void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    public void onContinuityTick(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 100.0f);
        for (LivingEntity target : targets) {
            if (!target.func_70644_a((Effect)ModEffects.SMOKE.get())) continue;
            AbilityHelper.setDeltaMovement((Entity)target, entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_186678_a(0.5));
            if (this.targetsToRemove.contains(target)) continue;
            this.targetsToRemove.add(target);
        }
    }

    public void onContinuityEnd(LivingEntity entity, IAbility ability) {
        for (LivingEntity target : this.targetsToRemove) {
            target.func_195063_d((Effect)ModEffects.SMOKE.get());
        }
        this.targetsToRemove.clear();
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

