/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WhiteStrikeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "white_strike", new Pair[]{ImmutablePair.of((Object)"Surrounds the nearby area with smoke, slowing down nearby entities", null)});
    private static final int HOLD_TIME = 40;
    private static final int COOLDOWN = 400;
    private static final float RANGE = 10.0f;
    public static final AbilityCore<WhiteStrikeAbility> INSTANCE = new AbilityCore.Builder<WhiteStrikeAbility>("White Strike", AbilityCategory.DEVIL_FRUITS, WhiteStrikeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ContinuousComponent.getTooltip(40.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public WhiteStrikeAbility(AbilityCore<WhiteStrikeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 40.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
            for (LivingEntity target : targets) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.SMOKE.get(), 800, 0, false, false));
            }
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.WHITE_STRIKE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

