/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.netsu;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NekkaiJigokuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "nekkai_jigoku", new Pair[]{ImmutablePair.of((Object)"Boils water around the user, damaging entities inside it.", null)});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 20;
    private static final int MAX_COOLDOWN = 300;
    private static final int RANGE = 30;
    public static final AbilityCore<NekkaiJigokuAbility> INSTANCE = new AbilityCore.Builder<NekkaiJigokuAbility>("Nekkai Jigoku", AbilityCategory.DEVIL_FRUITS, NekkaiJigokuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 300.0f), ContinuousComponent.getTooltip(600.0f), RangeComponent.getTooltip(30.0f, RangeComponent.RangeType.AOE)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public NekkaiJigokuAbility(AbilityCore<NekkaiJigokuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 600.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 30.0f);
        List<BlockPos> blocks = WyHelper.getNearbyBlocks((Entity)entity, 30);
        for (LivingEntity target : targets) {
            if (!target.func_70090_H()) continue;
            target.func_70097_a(DamageSource.field_76370_b, 2.0f);
        }
        if (!entity.field_70170_p.field_72995_K) {
            BlockPos.Mutable blockUp = new BlockPos.Mutable();
            for (BlockPos blockPos : blocks) {
                blockUp.func_181079_c(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p());
                if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() != Blocks.field_150355_j || entity.field_70170_p.func_180495_p((BlockPos)blockUp).func_177230_c() != Blocks.field_150350_a || this.continuousComponent.getContinueTime() % 5.0f != 0.0f) continue;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197612_e, (ServerWorld)entity.field_70170_p, (double)blockPos.func_177958_n() + WyHelper.randomDouble() / 2.0, (double)blockPos.func_177956_o() + 0.8, (double)blockPos.func_177952_p() + WyHelper.randomDouble() / 2.0);
            }
        }
    }
}

