/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nikyu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NikyuPushAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "nikyu_push", new Pair[]{ImmutablePair.of((Object)"Allows the user to push themselves in the direction they're looking at incredible speed", null)});
    private static final float MAX_TELEPORT_DISTANCE = 100.0f;
    private static final int COOLDOWN = 140;
    public static final AbilityCore<NikyuPushAbility> INSTANCE = new AbilityCore.Builder<NikyuPushAbility>("Nikyu Push", AbilityCategory.DEVIL_FRUITS, NikyuPushAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f)).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    private boolean hasFallDamage = true;

    public NikyuPushAbility(AbilityCore<NikyuPushAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.damageTakenComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, 100.0);
        BlockPos blockpos = mop == null || mop.func_216346_c() == RayTraceResult.Type.MISS ? WyHelper.rayTraceBlockSafe(entity, 64.0f) : WyHelper.getClearPositionForPlayer(entity, mop.func_216350_a());
        if (blockpos == null) {
            blockpos = WyHelper.rayTraceBlockSafe(entity, 64.0f);
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PAD_HO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        entity.func_184210_p();
        entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        this.hasFallDamage = false;
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }
}

