/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.noro;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KyubiRushAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kyubi_rush", new Pair[]{ImmutablePair.of((Object)"While the opponent is slowed, the user delivers a series of punches, which hits the opponent all at once (a stronger slowness effect causes more damage)", null)});
    private static final float COOLDOWN = 100.0f;
    private static final float MIN_DAMAGE = 1.0f;
    private static final float MAX_DAMAGE = 100.0f;
    private static final AbilityDescriptionLine.IDescriptionLine STATS_TOOLTIP = (entity, ability) -> {
        TranslationTextComponent attackAttrName = new TranslationTextComponent(Attributes.field_233823_f_.func_233754_c_());
        ITextComponent attackStatText = new AbilityStat.Builder((ITextComponent)attackAttrName, 1.0f, 100.0f).build().getStatDescription(2);
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STATS.getString() + "\u00a7r\n");
        sb.append(attackStatText.getString());
        return new StringTextComponent(sb.toString());
    };
    public static final AbilityCore<KyubiRushAbility> INSTANCE = new AbilityCore.Builder<KyubiRushAbility>("Kyubi Rush", AbilityCategory.DEVIL_FRUITS, KyubiRushAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f), STATS_TOOLTIP).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public KyubiRushAbility(AbilityCore<KyubiRushAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.dealDamageComponent);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        float damageFromSlowness = 0.0f;
        if (target.func_70644_a((Effect)ModEffects.NORO_SLOWNESS.get())) {
            damageFromSlowness = Math.min((float)target.func_70660_b((Effect)ModEffects.NORO_SLOWNESS.get()).func_76459_b() / 15.0f, 100.0f);
            int newTime = target.func_70660_b((Effect)ModEffects.NORO_SLOWNESS.get()).func_76459_b() / 2;
            int newAmplifier = Math.min(target.func_70660_b((Effect)ModEffects.NORO_SLOWNESS.get()).func_76458_c() - 2, 0);
            target.func_195063_d((Effect)ModEffects.NORO_SLOWNESS.get());
            target.func_195064_c(new EffectInstance((Effect)ModEffects.NORO_SLOWNESS.get(), newTime, newAmplifier));
        } else {
            damageFromSlowness = 1.0f;
        }
        WyHelper.spawnDamageIndicatorParticles(entity.field_70170_p, target, Math.round(damageFromSlowness));
        this.dealDamageComponent.hurtTarget(entity, target, damageFromSlowness, source.ignore());
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 100.0f;
    }
}

