/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.ope.OpeHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class GammaKnifeAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gamma_knife", new Pair[]{ImmutablePair.of((Object)"Creates a blade of gamma radiation which massively damages the opponent's organs", null)});
    private static final float COOLDOWN = 500.0f;
    public static final AbilityCore<GammaKnifeAbility> INSTANCE = new AbilityCore.Builder<GammaKnifeAbility>("Gamma Knife", AbilityCategory.DEVIL_FRUITS, GammaKnifeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(500.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).build();
    private final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent(this);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("171d7b97-319e-4f2f-84c3-0882d82444ae"), INSTANCE, "Gamma Knife Strength Modifier", 70.0, AttributeModifier.Operation.ADDITION);

    public GammaKnifeAbility(AbilityCore<GammaKnifeAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addTickEvent(100, this::onContinuityTick).addEndEvent(100, this::onContinuityEnd);
        this.statsComponent.addAttributeModifier(Attributes.field_233823_f_, (AttributeModifier)STRENGTH_MODIFIER, this.canActivate());
        super.addComponents(this.itemSpawnComponent);
        super.addCanUseCheck(OpeHelper::hasRoomActive);
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.spawnItem(entity, new ItemStack((IItemProvider)ModWeapons.GAMMA_KNIFE.get()), EquipmentSlotType.MAINHAND, true);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (OpeHelper.hasRoomActive(entity, this).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.despawnItems(entity);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        source.bypassLogia().setPiercing(1.0f);
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_77973_b().equals(ModWeapons.GAMMA_KNIFE.get());
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchCooldown() {
        return 500.0f;
    }
}

