/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ori;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class GreatCageAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "great_cage", new Pair[]{ImmutablePair.of((Object)"Creates a big cage trapping the user and all nearby entities in it.", null)});
    private static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 40;
    private static final int MAX_COOLDOWN = 340;
    public static final AbilityCore<GreatCageAbility> INSTANCE = new AbilityCore.Builder<GreatCageAbility>("Great Cage", AbilityCategory.DEVIL_FRUITS, GreatCageAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 340.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE).setBypassGriefRule().build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    protected List<BlockPos> blockList = new ArrayList<BlockPos>();

    public GreatCageAbility(AbilityCore<GreatCageAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.blockList.isEmpty()) {
            this.blockList.addAll(AbilityHelper.createEmptyCube((Entity)entity, (double)((int)entity.func_226277_ct_() - 1), (double)((int)entity.func_226278_cu_()), (double)((int)entity.func_226281_cx_() - 1), 20, 20, 20, 258, (Block)ModBlocks.ORI_BARS.get(), GRIEF_RULE));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        for (BlockPos pos : this.blockList) {
            Block currentBlock = entity.field_70170_p.func_180495_p(pos).func_177230_c();
            if (currentBlock != ModBlocks.ORI_BARS.get()) continue;
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.blockList.clear();
        float cooldown = 40.0f + this.continuousComponent.getContinueTime() / 4.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

