/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.oto;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class DonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "don", new Pair[]{ImmutablePair.of((Object)"The user plays the drum, creating a explosion inside all who hear it", null)});
    private static final float COOLDOWN = 60.0f;
    private static final float VOLUME = 3.0f;
    private static final int DISTANCE = 24;
    private static final float WIDTH = 3.0f;
    private static final float DAMAGE = 25.0f;
    private static final int ANIMATION_TICKS = 20;
    public static final AbilityCore<DonAbility> INSTANCE = new AbilityCore.Builder<DonAbility>("Don", AbilityCategory.DEVIL_FRUITS, DonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f), DealDamageComponent.getTooltip(25.0f), RangeComponent.getTooltip(24.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(SourceType.INTERNAL).setSourceElement(SourceElement.EXPLOSION).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public DonAbility(AbilityCore<DonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DON.get(), SoundCategory.PLAYERS, 3.0f, 0.2f + entity.func_70681_au().nextFloat());
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 24.0f, 3.0f);
        this.animationComponent.start(entity, ModAnimations.DON, 20);
        for (LivingEntity target : targets) {
            if (target.func_70644_a((Effect)ModEffects.SILENT.get())) continue;
            AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
            source.setInternal();
            source.markIndirectDamage();
            if (!this.dealDamageComponent.hurtTarget(entity, target, 25.0f, source)) continue;
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)target, target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.0f);
            explosion.setStaticDamage(25.0f);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(1));
            explosion.doExplosion();
            break;
        }
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }
}

