/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.oto;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shan", new Pair[]{ImmutablePair.of((Object)"The user turns their head into a cymbal, by pushing their own head they create a sound shockwave powerful enough to internally cut any entity hearing it", null)});
    private static final float COOLDOWN = 60.0f;
    private static final float VOLUME = 3.0f;
    private static final int DISTANCE = 24;
    private static final float WIDTH = 3.0f;
    private static final float DAMAGE = 25.0f;
    private static final int ANIMATION_TICKS = 20;
    public static final AbilityCore<ShanAbility> INSTANCE = new AbilityCore.Builder<ShanAbility>("Shan", AbilityCategory.DEVIL_FRUITS, ShanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f), DealDamageComponent.getTooltip(25.0f), RangeComponent.getTooltip(24.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(SourceType.INTERNAL).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public ShanAbility(AbilityCore<ShanAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SHAN.get(), SoundCategory.PLAYERS, 3.0f, 0.2f + entity.func_70681_au().nextFloat());
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 24.0f, 3.0f);
        this.animationComponent.start(entity, ModAnimations.SHAN, 20);
        for (LivingEntity target : targets) {
            if (target.func_70644_a((Effect)ModEffects.SILENT.get())) continue;
            AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
            source.setInternal();
            source.setSlash();
            source.markIndirectDamage();
            if (!this.dealDamageComponent.hurtTarget(entity, target, 25.0f, source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 100, 0));
            for (int i = 0; i < 5; ++i) {
                double offsetX = target.func_70681_au().nextDouble() / 2.0;
                double offsetZ = target.func_70681_au().nextDouble() / 2.0;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target.func_226277_ct_() + offsetX, target.func_226278_cu_() + (double)target.func_70047_e() + offsetX, target.func_226281_cx_() + offsetZ);
            }
        }
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }
}

