/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.rokushiki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.rokushiki.RankyakuProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;

public class RankyakuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "rankyaku", new Pair[]{ImmutablePair.of((Object)"By kicking at a very high speed, the user launches an air blade at the opponent", null)});
    public static final float COOLDOWN = 240.0f;
    public static final AbilityCore<RankyakuAbility> INSTANCE = new AbilityCore.Builder<RankyakuAbility>("Rankyaku", AbilityCategory.RACIAL, RankyakuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.AIR).setSourceType(SourceType.SLASH, SourceType.FIST, SourceType.INDIRECT).setUnlockCheck(RankyakuAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public RankyakuAbility(AbilityCore<RankyakuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.25f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private RankyakuProjectile createProjectile(LivingEntity entity) {
        RankyakuProjectile proj = new RankyakuProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        boolean raceCheck = props.isHuman() || DevilFruitCapability.get(user).hasDevilFruit(ModAbilities.HITO_HITO_NO_MI);
        return raceCheck && props.getDoriki() >= 5000.0;
    }
}

