/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.rokushiki;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class SoruAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "soru", new Pair[]{ImmutablePair.of((Object)"Allows the user to move at an extremely high speed in bursts", null)});
    private static final float LONG_COOLDOWN = 200.0f;
    private static final float SHORT_COOLDOWN = 10.0f;
    public static final AbilityCore<SoruAbility> INSTANCE = new AbilityCore.Builder<SoruAbility>("Soru", AbilityCategory.RACIAL, SoruAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, AbilityHelper.createShortLongCooldownStat(10.0f, 200.0f)).setUnlockCheck(SoruAbility::canUnlock).build();
    private final StackComponent stackComponent = new StackComponent(this, 5).addStackChangeEvent(this::onStacksChange);

    public SoruAbility(AbilityCore<SoruAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.stackComponent);
        this.setOGCD();
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_216372_d(1.75, entity.func_70040_Z().field_72448_b >= 0.0 ? 0.0 : 0.6, 1.75);
        if (entity.field_191988_bg < 0.0f) {
            look = look.func_216372_d(-1.0, 1.0, -1.0);
        }
        if (entity.func_70090_H()) {
            look = look.func_216372_d(0.2, 0.2, 0.2);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, look);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 5, 0, false, false));
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.stackComponent.addStacks(entity, this, -1);
    }

    private void onStacksChange(LivingEntity entity, IAbility ability, int stacks) {
        if (stacks <= 0) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
            this.stackComponent.revertStacksToDefault(entity, this);
        }
        this.cooldownComponent.startCooldown(entity, 10.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        boolean raceCheck = props.isHuman() || DevilFruitCapability.get(user).hasDevilFruit(ModAbilities.HITO_HITO_NO_MI);
        return raceCheck && props.getDoriki() >= 500.0;
    }
}

