/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryuallosaurus;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AncientBiteAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ancient_bite", new Pair[]{ImmutablePair.of((Object)"Bites the enemy dealing moderate damage.", null)});
    private static final int COOLDOWN = 140;
    public static final AbilityCore<AncientBiteAbility> INSTANCE = new AbilityCore.Builder<AncientBiteAbility>("Ancient Bite", AbilityCategory.DEVIL_FRUITS, AncientBiteAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.ALLOSAURUS_HEAVY.get(), (MorphInfo)ModMorphs.ALLOSAURUS_WALK.get());

    public AncientBiteAbility(AbilityCore<AncientBiteAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.requireMorphComponent);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        double x = WyHelper.randomDouble() * 2.0;
        double y = WyHelper.randomDouble() * 0.3;
        double z = WyHelper.randomDouble() * 2.0;
        entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, target.func_226277_ct_(), target.func_226278_cu_() + 1.0, target.func_226281_cx_(), x, y, z);
        target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 20, 0));
        for (int i = 0; i < 50; ++i) {
            Vector3d vec3d = new Vector3d(((double)entity.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.func_178789_a(-entity.field_70125_A * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-entity.field_70177_z * ((float)Math.PI / 180));
            ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197614_g, target.func_226277_ct_(), target.func_226278_cu_() + 1.5, target.func_226281_cx_(), 1, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.8);
        }
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchDamage() {
        return 20.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 140.0f;
    }

    @Override
    public boolean isParallel() {
        return true;
    }
}

