/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.saraaxolotl;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AxolotlHealAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "axolotl_heal", new Pair[]{ImmutablePair.of((Object)"Regenerates all friendlies nearby based on how many other Axolotls are around.", null)});
    private static final int COOLDOWN = 300;
    private static final float RANGE = 15.0f;
    private static final TargetsPredicate TARGET_PREDICATE = new TargetsPredicate().testFriendlyFaction().selector(target -> target instanceof PlayerEntity && DevilFruitCapability.get(target).hasDevilFruit(ModAbilities.SARA_SARA_NO_MI_AXOLOTL));
    public static final AbilityCore<AxolotlHealAbility> INSTANCE = new AbilityCore.Builder<AxolotlHealAbility>("Axolotl Heal", AbilityCategory.DEVIL_FRUITS, AxolotlHealAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), RangeComponent.getTooltip(15.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.AXOLOTL_HEAVY.get(), (MorphInfo)ModMorphs.AXOLOTL_WALK.get());

    public AxolotlHealAbility(AbilityCore<AxolotlHealAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.requireMorphComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 15.0f, TARGET_PREDICATE);
        int axolots = targets.size();
        axolots = Math.min(axolots, 3);
        int time = 100 + Math.min(axolots * 100, 300);
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, time, axolots));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHIYUPOPO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

