/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.saraaxolotl;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.saraaxolotl.PoisonSpitProjectile;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class PoisonSpitAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "poison_spit", new Pair[]{ImmutablePair.of((Object)"Spits a small dose of poison.", null)});
    private static final int COOLDOWN = 140;
    public static final AbilityCore<PoisonSpitAbility> INSTANCE = new AbilityCore.Builder<PoisonSpitAbility>("Poison Spit", AbilityCategory.DEVIL_FRUITS, PoisonSpitAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.AXOLOTL_HEAVY.get(), (MorphInfo)ModMorphs.AXOLOTL_WALK.get());

    public PoisonSpitAbility(AbilityCore<PoisonSpitAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.requireMorphComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private PoisonSpitProjectile createProjectile(LivingEntity entity) {
        PoisonSpitProjectile proj = new PoisonSpitProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

