/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sniper;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.sniper.HissatsuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BowTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.KemuriBoshiProjectile;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class KemuriBoshiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kemuri_boshi", new Pair[]{ImmutablePair.of((Object)"Fires a pellet that releases smoke on impact, poisoning and confusing targets", null)});
    private static final float COOLDOWN = 120.0f;
    public static final AbilityCore<KemuriBoshiAbility> INSTANCE = new AbilityCore.Builder<KemuriBoshiAbility>("Kemuri Boshi", AbilityCategory.STYLE, KemuriBoshiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f), ContinuousComponent.getTooltip()).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.BULLET).setUnlockCheck(KemuriBoshiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this);
    private final BowTriggerComponent bowTriggerComponent = new BowTriggerComponent(this).addShootEvent(this::shoot);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public KemuriBoshiAbility(AbilityCore<KemuriBoshiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.bowTriggerComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    public boolean shoot(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            boolean isHitScan = HissatsuAbility.checkHitScan(entity);
            this.projectileComponent.setHitScan(isHitScan);
            this.projectileComponent.shoot(entity, 4.0f, 1.0f);
            this.continuousComponent.stopContinuity(entity);
            this.cooldownComponent.startCooldown(entity, 120.0f);
            return true;
        }
        return false;
    }

    public KemuriBoshiProjectile createProjectile(LivingEntity entity) {
        KemuriBoshiProjectile proj = new KemuriBoshiProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isSniper() && questProps.hasFinishedQuest(ModQuests.SNIPER_TRIAL_02);
    }
}

