/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GroundSeccoAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ground_secco", new Pair[]{ImmutablePair.of((Object)"Dries out the area around the user.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 200;
    private static final int CHARGE_TIME = 60;
    private static final int DISTANCE = 20;
    private static final int SIZE = 15;
    public static final AbilityCore<GroundSeccoAbility> INSTANCE = new AbilityCore.Builder<GroundSeccoAbility>("Ground Secco", AbilityCategory.DEVIL_FRUITS, GroundSeccoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(200.0f), ChargeComponent.getTooltip(60.0f)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(this::endContinuityEvent);
    private final AltModeComponent<Pattern> altModeComponent = new AltModeComponent<Pattern>(this, Pattern.class, Pattern.CENTER);
    private Map<BlockPos, Set<BlockPos>> pools = new HashMap<BlockPos, Set<BlockPos>>();
    private Set<BlockPos> addedBlocks = new HashSet<BlockPos>();
    private int distance = 20;
    private int size = 15;
    private float sizeMod = 1.0f;

    public GroundSeccoAbility(AbilityCore<GroundSeccoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.altModeComponent, this.chargeComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(SunaHelper::requiresInactiveDesertGirasole);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos arenaCenter = entity.func_233580_cy_();
        ChallengesWorldData worldData = ChallengesWorldData.get();
        InProgressChallenge ch = worldData.getInProgressChallengeFor((ServerWorld)entity.field_70170_p);
        if (ch != null) {
            arenaCenter = new BlockPos(ch.getArenaPos().func_177958_n(), entity.func_233580_cy_().func_177956_o(), ch.getArenaPos().func_177952_p());
            this.distance = 30;
        }
        Pattern pattern = this.altModeComponent.getCurrentMode();
        pattern.create(this, entity.field_70170_p, arenaCenter);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            block0: for (Map.Entry<BlockPos, Set<BlockPos>> pools : this.pools.entrySet()) {
                if (pools.getValue().size() <= 0) continue;
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DESERT_ENCIERRO.get(), (Entity)entity, pools.getKey().func_177958_n(), pools.getKey().func_177956_o(), pools.getKey().func_177952_p());
                int toReplace = 200;
                Iterator<BlockPos> iterator = pools.getValue().iterator();
                while (iterator.hasNext()) {
                    BlockPos blockPos = iterator.next();
                    if (toReplace-- < 0) continue block0;
                    if (AbilityHelper.placeBlockIfAllowed(entity, blockPos, ((Block)ModBlocks.SUNA_SAND.get()).func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID)) {
                        this.addedBlocks.add(blockPos);
                    }
                    iterator.remove();
                }
            }
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 200.0f);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        for (BlockPos pos : this.addedBlocks) {
            entity.field_70170_p.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 2);
        }
        this.pools.clear();
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private static void setupCornersPattern(GroundSeccoAbility ability, World world, BlockPos arenaCenter) {
        BlockPos pos1 = arenaCenter.func_177965_g(ability.distance).func_177964_d(ability.distance);
        Set<BlockPos> blocks1 = GroundSeccoAbility.createCircle(ability, world, pos1, ability.size);
        BlockPos pos2 = arenaCenter.func_177985_f(ability.distance).func_177964_d(ability.distance);
        Set<BlockPos> blocks2 = GroundSeccoAbility.createCircle(ability, world, pos2, ability.size);
        BlockPos pos3 = arenaCenter.func_177965_g(ability.distance).func_177970_e(ability.distance);
        Set<BlockPos> blocks3 = GroundSeccoAbility.createCircle(ability, world, pos3, ability.size);
        BlockPos pos4 = arenaCenter.func_177985_f(ability.distance).func_177970_e(ability.distance);
        Set<BlockPos> blocks4 = GroundSeccoAbility.createCircle(ability, world, pos4, ability.size);
        ability.pools.put(pos1, blocks1);
        ability.pools.put(pos2, blocks2);
        ability.pools.put(pos3, blocks3);
        ability.pools.put(pos4, blocks4);
    }

    private static void setupCirclePattern(GroundSeccoAbility ability, World world, BlockPos arenaCenter) {
        BlockPos pos1 = arenaCenter.func_177964_d(ability.distance);
        Set<BlockPos> blocks1 = GroundSeccoAbility.createCircle(ability, world, pos1, ability.size);
        BlockPos pos2 = arenaCenter.func_177964_d(ability.distance).func_177965_g(ability.distance);
        Set<BlockPos> blocks2 = GroundSeccoAbility.createCircle(ability, world, pos2, ability.size);
        BlockPos pos3 = arenaCenter.func_177965_g(ability.distance);
        Set<BlockPos> blocks3 = GroundSeccoAbility.createCircle(ability, world, pos3, ability.size);
        BlockPos pos4 = arenaCenter.func_177970_e(ability.distance).func_177965_g(ability.distance);
        Set<BlockPos> blocks4 = GroundSeccoAbility.createCircle(ability, world, pos4, ability.size);
        BlockPos pos5 = arenaCenter.func_177970_e(ability.distance);
        Set<BlockPos> blocks5 = GroundSeccoAbility.createCircle(ability, world, pos5, ability.size);
        BlockPos pos6 = arenaCenter.func_177970_e(ability.distance).func_177985_f(ability.distance);
        Set<BlockPos> blocks6 = GroundSeccoAbility.createCircle(ability, world, pos6, ability.size);
        BlockPos pos7 = arenaCenter.func_177985_f(ability.distance);
        Set<BlockPos> blocks7 = GroundSeccoAbility.createCircle(ability, world, pos7, ability.size);
        BlockPos pos8 = arenaCenter.func_177964_d(ability.distance).func_177985_f(ability.distance);
        Set<BlockPos> blocks8 = GroundSeccoAbility.createCircle(ability, world, pos8, ability.size);
        ability.pools.put(pos1, blocks1);
        ability.pools.put(pos2, blocks2);
        ability.pools.put(pos3, blocks3);
        ability.pools.put(pos4, blocks4);
        ability.pools.put(pos5, blocks5);
        ability.pools.put(pos6, blocks6);
        ability.pools.put(pos7, blocks7);
        ability.pools.put(pos8, blocks8);
    }

    private static void setupCenterPattern(GroundSeccoAbility ability, World world, BlockPos arenaCenter) {
        int size = ability.size * 2;
        Set<BlockPos> blocks = GroundSeccoAbility.createCircle(ability, world, arenaCenter, size);
        ability.pools.put(arenaCenter, blocks);
    }

    private static void setupCrossPattern(GroundSeccoAbility ability, World world, BlockPos arenaCenter) {
        Set<BlockPos> blocks1 = GroundSeccoAbility.createCircle(ability, world, arenaCenter, ability.size);
        BlockPos pos2 = arenaCenter.func_177964_d(ability.distance);
        Set<BlockPos> blocks2 = GroundSeccoAbility.createCircle(ability, world, pos2, ability.size);
        BlockPos pos3 = arenaCenter.func_177970_e(ability.distance);
        Set<BlockPos> blocks3 = GroundSeccoAbility.createCircle(ability, world, pos3, ability.size);
        BlockPos pos4 = arenaCenter.func_177965_g(ability.distance);
        Set<BlockPos> blocks4 = GroundSeccoAbility.createCircle(ability, world, pos4, ability.size);
        BlockPos pos5 = arenaCenter.func_177985_f(ability.distance);
        Set<BlockPos> blocks5 = GroundSeccoAbility.createCircle(ability, world, pos5, ability.size);
        ability.pools.put(arenaCenter, blocks1);
        ability.pools.put(pos2, blocks2);
        ability.pools.put(pos3, blocks3);
        ability.pools.put(pos4, blocks4);
        ability.pools.put(pos5, blocks5);
    }

    private static Set<BlockPos> createCircle(GroundSeccoAbility ability, World world, BlockPos pos, int size) {
        int finalSize = Math.round((float)size * ability.sizeMod);
        BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        BlockState state = ((Block)ModBlocks.SUNA_SAND.get()).func_176223_P();
        for (int i = -finalSize; i < finalSize; ++i) {
            for (int j = -3; j < 3; ++j) {
                for (int k = -finalSize; k < finalSize; ++k) {
                    if (i * i + k * k > finalSize * finalSize) continue;
                    mutpos.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                    if (!AbilityHelper.canPlaceBlock(world, mutpos.func_177958_n(), mutpos.func_177956_o(), mutpos.func_177952_p(), state, 3, DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID)) continue;
                    blockPlacingHelper.addBlockPos(mutpos.func_185334_h(), i * i + j * j + k * k);
                }
            }
        }
        return blockPlacingHelper.getBlockList();
    }

    public void changePattern(LivingEntity entity, Pattern pattern) {
        this.altModeComponent.setMode(entity, pattern);
    }

    public void changeRandomPattern(LivingEntity entity) {
        Pattern pattern = Pattern.values()[entity.func_70681_au().nextInt(Pattern.values().length - 1)];
        this.altModeComponent.setMode(entity, pattern);
    }

    public void setSizeModifier(float mod) {
        this.sizeMod = mod;
    }

    @FunctionalInterface
    private static interface IPatternFunction {
        public void create(GroundSeccoAbility var1, World var2, BlockPos var3);
    }

    public static enum Pattern {
        CIRCLE((x$0, x$1, x$2) -> GroundSeccoAbility.access$300(x$0, x$1, x$2)),
        CROSS((x$0, x$1, x$2) -> GroundSeccoAbility.access$200(x$0, x$1, x$2)),
        CORNERS((x$0, x$1, x$2) -> GroundSeccoAbility.access$100(x$0, x$1, x$2)),
        CENTER((x$0, x$1, x$2) -> GroundSeccoAbility.access$000(x$0, x$1, x$2));

        private IPatternFunction func;

        private Pattern(IPatternFunction func) {
            this.func = func;
        }

        public void create(GroundSeccoAbility ability, World world, BlockPos arenaCenter) {
            this.func.create(ability, world, arenaCenter);
        }
    }
}

