/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.TornadoEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class SablesGuardAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sables_guard", new Pair[]{ImmutablePair.of((Object)"The user starts a sandstorm with themselves as the center of it, sending all nearby enemies flying away.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 60;
    private static final int RANGE = 10;
    public static final AbilityCore<SablesGuardAbility> INSTANCE = new AbilityCore.Builder<SablesGuardAbility>("Sables Guard", AbilityCategory.DEVIL_FRUITS, SablesGuardAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(60.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).build();
    private final ContinuousComponent continuityComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private TornadoEntity proj = null;

    public SablesGuardAbility(AbilityCore<SablesGuardAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuityComponent, this.rangeComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuityComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.proj = null;
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        if (this.proj == null) {
            this.proj = new TornadoEntity(entity.field_70170_p, entity);
            this.proj.setMaxLife(60);
            this.proj.setSize(20.0f);
            this.proj.setSpeed(-2.0f);
            this.proj.func_70107_b(entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c);
            entity.field_70170_p.func_217376_c((Entity)this.proj);
        }
        if (!this.proj.func_70089_S() || this.proj == null) {
            this.continuityComponent.stopContinuity(entity);
            return;
        }
        if (this.continuityComponent.getContinueTime() % 5.0f == 0.0f) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f);
            for (LivingEntity target : targets) {
                Vector3d moveVec = target.func_213303_ch().func_178788_d(this.proj.func_213303_ch()).func_72432_b().func_216372_d(4.0, 1.0, 4.0).func_72441_c(0.0, 1.0, 0.0);
                AbilityHelper.setDeltaMovement((Entity)target, moveVec);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.proj != null && this.proj.func_70089_S()) {
            this.proj.func_70106_y();
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

