/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import java.util.List;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AtomicRushAbility
extends Ability {
    private static final ResourceLocation ICON = new ResourceLocation("mineminenomi", "textures/abilities/atomic_spurt.png");
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<AtomicRushAbility> INSTANCE = new AbilityCore.Builder<IAbility>("Atomic Rush", AbilityCategory.DEVIL_FRUITS, AtomicRushAbility::new).setIcon(ICON).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private Interval newPosInterval = new Interval(20);
    private Interval dashWait = new Interval(5);
    private int damageTimer = 0;
    private LivingEntity target;

    public AtomicRushAbility(AbilityCore<AtomicRushAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTrackerComponent, this.animationComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.target = null;
        this.hitTrackerComponent.clearHits();
        this.continuousComponent.triggerContinuity(entity, WyHelper.secondsToTicks(10.0f));
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.dashWait.restartIntervalToZero();
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        List<Object> targets;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.target != null && this.dashWait.canTick()) {
            this.hitTrackerComponent.clearHits();
            Vector3d dir = entity.func_213303_ch().func_178788_d(this.target.func_213303_ch()).func_72432_b().func_216372_d(7.0, 0.0, 7.0);
            AbilityHelper.setDeltaMovement((Entity)entity, -dir.field_72450_a, 0.15, -dir.field_72449_c);
            this.target = null;
            this.damageTimer = 5;
        }
        if (this.damageTimer > 0) {
            --this.damageTimer;
            targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 1.6, ModEntityPredicates.getEnemyFactions(entity));
            targets.remove(entity);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                target.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(entity, this), 25.0f);
            }
        }
        if (!this.newPosInterval.canTick()) {
            return;
        }
        targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 40.0, 40.0, 40.0, ModEntityPredicates.getEnemyFactions(entity));
        targets.remove(entity);
        if (targets.size() <= 0) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        LivingEntity target = targets.stream().sorted((e1, e2) -> (int)(e1.func_195048_a(entity.func_213303_ch()) - e2.func_195048_a(entity.func_213303_ch()))).findFirst().orElse(null);
        if (target == null) {
            return;
        }
        EffectInstance vanishEffect = new EffectInstance((Effect)ModEffects.VANISH.get(), 5, 0);
        entity.func_195064_c(vanishEffect);
        WyHelper.sendApplyEffectToAllNearby(entity, entity.func_213303_ch(), 100, vanishEffect);
        BlockPos pos = WyHelper.findValidGroundLocation((Entity)entity, target.func_233580_cy_(), 5, 5);
        entity.func_223102_j((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        this.target = target;
        entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    public void setDashWaitTime(int time) {
        this.dashWait = new Interval(time);
    }
}

