/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class SparClawAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spar_claw", new Pair[]{ImmutablePair.of((Object)"Turns the undersides of the user's fingers into blades to slash opponents with", null)});
    private static final float HOLD_TIME = 1000.0f;
    private static final float MIN_COOLDOWN = 20.0f;
    private static final float MAX_COOLDOWN = 1020.0f;
    public static final AbilityCore<SparClawAbility> INSTANCE = new AbilityCore.Builder<SparClawAbility>("Spar Claw", AbilityCategory.DEVIL_FRUITS, SparClawAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 1020.0f), ContinuousComponent.getTooltip(1000.0f), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setColor(new Color(113, 121, 126)).build();
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public SparClawAbility(AbilityCore<SparClawAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.skinOverlayComponent);
        this.continuousComponent.addStartEvent(100, this::continuousStartEvent);
        this.continuousComponent.addEndEvent(100, this::continuousStopEvent);
    }

    private void continuousStartEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void continuousStopEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 0;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchHoldTime() {
        return 1000.0f;
    }

    @Override
    public float getPunchDamage() {
        return 15.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 20.0f + this.continuousComponent.getContinueTime();
    }
}

