/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yomi;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.events.FactionEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SoulParadeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "soul_parade", new Pair[]{ImmutablePair.of((Object)"The user blocks incoming attacks, an enemy hitting them gets frozen immediately.", null)});
    private static final int HOLD_TIME = 300;
    private static final int MIN_COOLDOWN = 60;
    private static final int MAX_COOLDOWN = 360;
    public static final AbilityCore<SoulParadeAbility> INSTANCE = new AbilityCore.Builder<SoulParadeAbility>("Soul Parade", AbilityCategory.DEVIL_FRUITS, SoulParadeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f, 360.0f), ContinuousComponent.getTooltip(300.0f)).setSourceType(SourceType.SLASH).setSourceElement(SourceElement.ICE).setUnlockCheck(SoulParadeAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::damageTakenEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public SoulParadeAbility(AbilityCore<SoulParadeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent, this.poolComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 3, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        float cooldown = 60.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(entity)) {
            Entity sourceEntity = damageSource.func_76346_g();
            if (sourceEntity == null) {
                return damage;
            }
            if (sourceEntity instanceof LivingEntity && FactionEvents.isDirectHit(damageSource)) {
                LivingEntity attacker = (LivingEntity)sourceEntity;
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SOUL_PARADE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                attacker.func_195064_c(new EffectInstance(Effects.field_76421_d, 70, 1));
                attacker.func_195064_c(new EffectInstance(Effects.field_76419_f, 70, 1));
                attacker.func_195064_c(new EffectInstance((Effect)ModEffects.FROZEN.get(), 70, 0));
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), 2.0f);
                explosion.setDamageOwner(false);
                explosion.setDestroyBlocks(false);
                explosion.setDamageEntities(false);
                explosion.doExplosion();
            }
            this.continuousComponent.stopContinuity(entity);
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        return ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(entity);
    }
}

