/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class OneFruitEntry {
    private ResourceLocation fruitKey;
    private Optional<UUID> owner = Optional.empty();
    private Status status;
    private String statusMessage = "";
    private Date lastUpdate;
    private List<HistoryEntry> history = new ArrayList<HistoryEntry>();

    private OneFruitEntry() {
    }

    public OneFruitEntry(ResourceLocation key, @Nullable UUID owner, Status status, @Nullable String message) {
        this.fruitKey = key;
        if (!Strings.isNullOrEmpty((String)message)) {
            this.setStatusMessage(message);
        }
        this.update(owner, status);
    }

    public static OneFruitEntry from(CompoundNBT nbt) {
        OneFruitEntry entry = new OneFruitEntry();
        entry.load(nbt);
        return entry;
    }

    public ResourceLocation getKey() {
        return this.fruitKey;
    }

    public Optional<Item> getItemFromKey() {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getValue(this.fruitKey));
    }

    public Optional<UUID> getOwner() {
        return this.owner;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public void update(UUID owner, Status status) {
        this.owner = Optional.ofNullable(owner);
        this.status = status;
        this.lastUpdate = new Date();
        this.registerCurrentHistory();
    }

    public void forceLastUpdateNow() {
        this.lastUpdate = new Date();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void registerCurrentHistory() {
        this.history.add(new HistoryEntry(this.owner, this.status, this.statusMessage, this.lastUpdate));
        this.statusMessage = "";
    }

    public List<HistoryEntry> getHistory() {
        return this.history;
    }

    public CompoundNBT save() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("fruit", this.fruitKey.toString());
        if (this.owner.isPresent()) {
            nbt.func_186854_a("owner", this.owner.get());
        }
        nbt.func_74778_a("status", this.status.name());
        nbt.func_74772_a("lastUpdate", this.lastUpdate.getTime());
        ListNBT history = new ListNBT();
        int limit = Math.min(1000, this.history.size());
        List list = this.history.stream().skip(this.history.size() - limit).limit(limit).collect(Collectors.toList());
        for (HistoryEntry entry : list) {
            CompoundNBT entryNBT = entry.save();
            history.add((Object)entryNBT);
        }
        nbt.func_218657_a("history", (INBT)history);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        this.fruitKey = new ResourceLocation(nbt.func_74779_i("fruit"));
        if (nbt.func_186855_b("owner")) {
            this.owner = Optional.ofNullable(nbt.func_186857_a("owner"));
        }
        this.status = Status.valueOf(nbt.func_74779_i("status"));
        this.lastUpdate = new Date(nbt.func_74763_f("lastUpdate"));
        ListNBT history = nbt.func_150295_c("history", 10);
        this.history.clear();
        for (int i = 0; i < history.size(); ++i) {
            CompoundNBT historyNBT = history.func_150305_b(i);
            this.history.add(HistoryEntry.from(historyNBT));
        }
    }

    public static class HistoryEntry {
        private Optional<UUID> owner = Optional.empty();
        private Status status;
        private String statusMessage = "";
        private Date date;

        private HistoryEntry() {
        }

        public HistoryEntry(Optional<UUID> owner, Status status, String statusMessage, Date date) {
            this.owner = owner;
            this.status = status;
            this.statusMessage = statusMessage;
            this.date = date;
        }

        public static HistoryEntry from(CompoundNBT nbt) {
            HistoryEntry entry = new HistoryEntry();
            entry.load(nbt);
            return entry;
        }

        public Optional<UUID> getOwner() {
            return this.owner;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Date getDate() {
            return this.date;
        }

        public CompoundNBT save() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.owner.isPresent()) {
                nbt.func_186854_a("uuid", this.owner.get());
            }
            nbt.func_74778_a("status", this.status.name());
            nbt.func_74778_a("statusMessage", this.statusMessage);
            nbt.func_74772_a("date", this.date.getTime());
            return nbt;
        }

        public void load(CompoundNBT nbt) {
            if (nbt.func_186855_b("uuid")) {
                this.owner = Optional.ofNullable(nbt.func_186857_a("uuid"));
            }
            this.status = Status.valueOf(nbt.func_74779_i("status"));
            this.statusMessage = nbt.func_74779_i("statusMessage");
            this.date = new Date(nbt.func_74763_f("date"));
        }
    }

    public static enum Status {
        DROPPED,
        INVENTORY,
        IN_USE,
        LOST;

    }
}

