/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import com.mojang.authlib.GameProfile;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.logging.log4j.LogManager;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.IRandomTexture;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WantedPosterData {
    private static final String[] WANTED_POSTER_BACKGROUNDS = new String[]{"forest1", "forest2", "jungle1", "jungle2", "hills1", "hills2", "hills3", "plains1", "plains2", "plains3", "taiga1", "taiga2"};
    private long id;
    private UUID ownerId;
    private String ownerName;
    private Optional<GameProfile> ownerProfile = Optional.empty();
    private Optional<ResourceLocation> skinTexture = Optional.empty();
    private Optional<Crew> ownerCrew = Optional.empty();
    private Optional<Vector3d> trackedPosition = Optional.empty();
    private ResourceLocation faction;
    private long bounty;
    private String bountyString;
    private String background;
    private String date;
    private Random random;
    private long seed;
    private boolean isExpired;

    private WantedPosterData() {
    }

    public WantedPosterData(LivingEntity entity, long bounty) {
        String dateString;
        this.seed = (long)entity.hashCode() + bounty;
        this.random = new Random(this.seed);
        this.ownerId = entity.func_110124_au();
        this.ownerName = entity.func_200200_C_().getString();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            this.ownerProfile = Optional.ofNullable(player.func_146103_bH());
        } else if (entity instanceof IRandomTexture) {
            ResourceLocation texture = ((IRandomTexture)entity).getCurrentTexture();
            this.skinTexture = texture == null ? Optional.ofNullable(((IRandomTexture)entity).getDefaultTexture()) : Optional.ofNullable(texture);
        }
        Crew crew = ExtendedWorldData.get().getCrewWithMember(this.ownerId);
        this.ownerCrew = Optional.ofNullable(crew);
        this.faction = EntityStatsCapability.get(entity).getFaction();
        this.bounty = bounty;
        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
        this.bountyString = decimalFormat.format(this.bounty);
        int randomBg = (int)WyHelper.randomWithRange(this.random, 0, WANTED_POSTER_BACKGROUNDS.length - 1);
        this.background = WANTED_POSTER_BACKGROUNDS[randomBg];
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.date = dateString = format.format(new Date());
    }

    public static WantedPosterData empty() {
        return new WantedPosterData();
    }

    public static WantedPosterData from(CompoundNBT nbt) {
        WantedPosterData wantedPoster = new WantedPosterData();
        if (nbt.isEmpty()) {
            LogManager.getLogger(WantedPosterData.class).warn("Wanted Poster Data created without any actual data!");
            return wantedPoster;
        }
        wantedPoster.ownerId = nbt.func_186857_a("UUID");
        wantedPoster.ownerName = nbt.func_74779_i("Name");
        if (nbt.func_150297_b("Owner", 10)) {
            wantedPoster.ownerProfile = Optional.ofNullable(NBTUtil.func_152459_a((CompoundNBT)nbt.func_74775_l("Owner")));
        }
        if (nbt.func_74764_b("Texture")) {
            wantedPoster.skinTexture = Optional.ofNullable(new ResourceLocation(nbt.func_74779_i("Texture")));
        }
        if (nbt.func_150297_b("TrackedPosition", 10)) {
            CompoundNBT trackedPos = nbt.func_74775_l("TrackedPosition");
            double x = trackedPos.func_74769_h("x");
            double y = trackedPos.func_74769_h("y");
            double z = trackedPos.func_74769_h("z");
            wantedPoster.trackedPosition = Optional.ofNullable(new Vector3d(x, y, z));
        }
        if (nbt.func_150297_b("Crew", 10)) {
            wantedPoster.ownerCrew = Optional.ofNullable(Crew.from(nbt.func_74775_l("Crew")));
        }
        wantedPoster.bounty = nbt.func_74763_f("Bounty");
        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
        wantedPoster.bountyString = decimalFormat.format(wantedPoster.bounty);
        wantedPoster.isExpired = nbt.func_74767_n("IsExpired");
        wantedPoster.faction = WyHelper.getResourceLocation(nbt, "Faction");
        wantedPoster.background = nbt.func_74779_i("Background");
        wantedPoster.date = nbt.func_74779_i("Date");
        wantedPoster.seed = nbt.func_74763_f("Seed");
        wantedPoster.random = new Random(wantedPoster.seed);
        return wantedPoster;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Optional<GameProfile> getOwnerProfile() {
        return this.ownerProfile;
    }

    public Optional<Crew> getOwnerCrew() {
        return this.ownerCrew;
    }

    public Optional<ResourceLocation> getOwnerTexture() {
        return this.skinTexture;
    }

    public ResourceLocation getFaction() {
        return this.faction;
    }

    public long getBounty() {
        return this.bounty;
    }

    public String getBountyString() {
        return this.bountyString;
    }

    public String getBackground() {
        return this.background;
    }

    public String getDate() {
        return this.date;
    }

    public boolean isExpired() {
        boolean hasEvent;
        EventsWorldData worldData;
        if (this.skinTexture.isPresent() && (worldData = EventsWorldData.get()) != null && !(hasEvent = worldData.hasNTEventFor(this.ownerId))) {
            return true;
        }
        return this.isExpired;
    }

    public void checkIfExpired() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        if (worldData == null) {
            LogManager.getLogger((Object)this).warn("Checking for expiration on client side! Something has gone wrong.");
            return;
        }
        this.isExpired = worldData.getBounty(this.ownerId) != this.bounty;
    }

    public void setTrackedPosition(Vector3d pos) {
        this.trackedPosition = Optional.ofNullable(pos);
    }

    public Optional<Vector3d> getTrackedPosition() {
        return this.trackedPosition;
    }

    public CompoundNBT write() {
        CompoundNBT data = new CompoundNBT();
        if (this.ownerId == null) {
            return data;
        }
        data.func_186854_a("UUID", this.ownerId);
        data.func_74778_a("Name", this.ownerName);
        data.func_74772_a("Bounty", this.bounty);
        data.func_74757_a("IsExpired", this.isExpired);
        data.func_74778_a("Faction", this.faction.toString());
        data.func_74778_a("Background", this.background);
        data.func_74778_a("Date", this.date);
        if (this.ownerProfile.isPresent()) {
            CompoundNBT gameProfileNBT = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)gameProfileNBT, (GameProfile)this.ownerProfile.get());
            data.func_218657_a("Owner", (INBT)gameProfileNBT);
        }
        if (this.skinTexture.isPresent()) {
            data.func_74778_a("Texture", this.skinTexture.get().toString());
        }
        if (this.trackedPosition.isPresent()) {
            CompoundNBT trackedPos = new CompoundNBT();
            trackedPos.func_74780_a("x", this.trackedPosition.get().field_72450_a);
            trackedPos.func_74780_a("y", this.trackedPosition.get().field_72448_b);
            trackedPos.func_74780_a("z", this.trackedPosition.get().field_72449_c);
            data.func_218657_a("TrackedPosition", (INBT)trackedPos);
        }
        if (this.ownerCrew.isPresent()) {
            data.func_218657_a("Crew", (INBT)this.ownerCrew.get().write());
        }
        data.func_74772_a("Seed", this.seed);
        return data;
    }
}

