/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.util.FloatRange;
import xyz.pixelatedw.mineminenomi.api.util.INumberRange;
import xyz.pixelatedw.mineminenomi.api.util.IntRange;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;

public class AbilityStat {
    private ITextComponent name;
    @Nullable
    private ITextComponent unit;
    private INumberRange<?> value;
    private INumberRange<?> bonus;
    private AbilityStatType bonusType;
    private boolean isBuff;
    private String sign;

    private AbilityStat(ITextComponent name, INumberRange<?> value) {
        this.name = name;
        this.value = value;
    }

    private void setUnit(ITextComponent unit) {
        this.unit = unit;
    }

    private void setBonus(INumberRange<?> bonus, AbilityStatType bonusType) {
        this.bonus = bonus;
        this.bonusType = bonusType;
    }

    private void setBuff(boolean flag) {
        this.isBuff = flag;
    }

    private void setSign(String sign) {
        this.sign = sign;
    }

    public ITextComponent getStatDescription() {
        return this.getStatDescription(0);
    }

    public ITextComponent getStatDescription(int indent) {
        Object[] params = new Object[20];
        int paramId = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("%s%s\u00a7r");
        params[paramId++] = this.isBuff ? "\u00a7a" : "\u00a7c";
        params[paramId++] = this.name.getString();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        float minBonus = 0.0f;
        float maxBonus = 0.0f;
        String bonusType = "";
        if (this.bonus != null && ClientConfig.INSTANCE.isAbilityBonusesMergeEnable()) {
            bonusType = this.bonusType.getColorCode();
            minBonus = ((Number)this.bonus.getMin()).floatValue();
            if (this.bonus.isFixed()) {
                maxBonus = minBonus;
            } else if (this.bonus.isRange()) {
                maxBonus = ((Number)this.bonus.getMax()).floatValue();
            }
        }
        if (this.value.isInfinite()) {
            sb.append(" \u221e");
        } else if (this.value.isRange()) {
            sb.append(" %s%s%s-%s\u00a7r");
            params[paramId++] = bonusType;
            params[paramId++] = this.sign;
            params[paramId++] = nf.format(((Number)this.value.getMin()).floatValue() + minBonus);
            params[paramId++] = nf.format(((Number)this.value.getMax()).floatValue() + maxBonus);
        } else {
            sb.append(" %s%s%s\u00a7r");
            params[paramId++] = this.sign;
            params[paramId++] = bonusType;
            params[paramId++] = nf.format(((Number)this.value.getMin()).floatValue() + minBonus);
        }
        if (this.unit != null) {
            sb.append(" %s");
            params[paramId++] = this.unit.getString();
        }
        if (indent > 0) {
            while (indent > 0) {
                sb.insert(0, " ");
                --indent;
            }
        }
        if (this.bonus != null && !ClientConfig.INSTANCE.isAbilityBonusesMergeEnable()) {
            float min = ((Number)this.bonus.getMin()).floatValue();
            float max = ((Number)this.bonus.getMax()).floatValue();
            if (this.bonus.isRange() && (min != 0.0f || max != 0.0f)) {
                sb.append(" (%s%s\u00a7r-%s%s\u00a7r)");
                params[paramId++] = this.bonusType.getColorCode() + "" + (min == 0.0f ? "" : (min > 0.0f ? "+" : ""));
                params[paramId++] = nf.format(this.bonus.getMin());
                params[paramId++] = this.bonusType.getColorCode() + "" + (max == 0.0f ? "" : (max > 0.0f ? "+" : ""));
                params[paramId++] = nf.format(this.bonus.getMax());
            } else if (this.bonus.isFixed() && min != 0.0f) {
                sb.append(" (%s%s\u00a7r)");
                params[paramId++] = this.bonusType.getColorCode() + "" + (min > 0.0f ? "+" : "");
                params[paramId++] = nf.format(this.bonus.getMin());
            }
        }
        return new StringTextComponent(String.format(sb.toString(), params));
    }

    public static enum AbilityStatType {
        NEUTRAL(""),
        BUFF("\u00a7a"),
        DEBUFF("\u00a7c");

        private String color;

        private AbilityStatType(String color) {
            this.color = color;
        }

        public String getColorCode() {
            return this.color;
        }
    }

    public static class Builder {
        private ITextComponent name;
        @Nullable
        private ITextComponent unit;
        private INumberRange<?> value;
        private INumberRange<?> bonus;
        private AbilityStatType bonusType = AbilityStatType.NEUTRAL;
        private boolean isStatBuff = true;
        private String sign = "";

        public Builder(ITextComponent name, float value) {
            this.name = name;
            this.value = new FloatRange(value);
        }

        public Builder(ITextComponent name, float min, float max) {
            this.name = name;
            this.value = new FloatRange(min, max);
        }

        public Builder(ITextComponent name, int value) {
            this.name = name;
            this.value = new IntRange(value);
        }

        public Builder(ITextComponent name, int min, int max) {
            this.name = name;
            this.value = new IntRange(min, max);
        }

        public Builder withUnit(ITextComponent unit) {
            this.unit = unit;
            return this;
        }

        public Builder withBonus(float bonus, AbilityStatType type) {
            this.bonus = new FloatRange(bonus);
            this.bonusType = type;
            return this;
        }

        public Builder withBonus(float minBonus, float maxBonus, AbilityStatType type) {
            this.bonus = new FloatRange(minBonus, maxBonus);
            this.bonusType = type;
            return this;
        }

        public Builder withBuff(boolean flag) {
            this.isStatBuff = flag;
            return this;
        }

        public Builder withSign(String sign) {
            this.sign = sign;
            return this;
        }

        public AbilityStat build() {
            AbilityStat stat = new AbilityStat(this.name, this.value);
            stat.setUnit(this.unit);
            stat.setBonus(this.bonus, this.bonusType);
            stat.setBuff(this.isStatBuff);
            stat.setSign(this.sign);
            return stat;
        }
    }
}

