/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class AbilityUseResult {
    private AbilityUseResultType result;
    @Nullable
    private ITextComponent message;

    public AbilityUseResult(AbilityUseResultType result, @Nullable ITextComponent message) {
        this.result = result;
        this.message = message;
    }

    public AbilityUseResultType getResult() {
        return this.result;
    }

    @Nullable
    public ITextComponent getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.getResult() == AbilityUseResultType.SUCCESS;
    }

    public boolean isSuccessOr(IOkCallback errorCallback) {
        if (this.isSuccess()) {
            return true;
        }
        errorCallback.callback(this.getMessage());
        return false;
    }

    public boolean isFail() {
        return this.getResult() == AbilityUseResultType.FAIL;
    }

    public static AbilityUseResult and(AbilityUseResult result1, AbilityUseResult result2) {
        return result1.isSuccess() && result2.isSuccess() ? AbilityUseResult.success() : (result1.isFail() ? AbilityUseResult.fail(result1.getMessage()) : AbilityUseResult.fail(result2.getMessage()));
    }

    public static AbilityUseResult or(AbilityUseResult result1, AbilityUseResult result2) {
        return result1.isSuccess() || result2.isSuccess() ? AbilityUseResult.success() : (result1.isFail() ? AbilityUseResult.fail(result1.getMessage()) : AbilityUseResult.fail(result2.getMessage()));
    }

    public static AbilityUseResult success() {
        return new AbilityUseResult(AbilityUseResultType.SUCCESS, null);
    }

    public static AbilityUseResult fail(@Nullable ITextComponent message) {
        return new AbilityUseResult(AbilityUseResultType.FAIL, message);
    }

    @FunctionalInterface
    public static interface IErrCallback<T> {
        public void callback(T var1);
    }

    @FunctionalInterface
    public static interface IOkCallback {
        public void callback(ITextComponent var1);
    }

    public static enum AbilityUseResultType {
        SUCCESS,
        FAIL;

    }
}

