/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.io.Serializable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAnimatedAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSyncAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Deprecated
public abstract class ChargeableAbility
extends Ability {
    private int chargeTime;
    private int maxChargeTime;
    private boolean isCancelable;
    protected IOnStartCharging onStartChargingEvent = player -> true;
    protected IOnEndCharging onEndChargingEvent = player -> true;
    protected IDuringCharging duringChargingEvent = (player, chargeTime) -> {};

    public ChargeableAbility(AbilityCore core) {
        super(core);
    }

    @Override
    public void use(PlayerEntity player) {
        AbilityUseEvent.Pre pre;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isOnCooldown() && this.getCooldown() <= 10.0) {
            this.stopCooldown(player);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(pre = new AbilityUseEvent.Pre((LivingEntity)player, this)))) {
            return;
        }
        if (this.isCharging() && this.chargeTime > 0) {
            this.endCharging(player);
        } else if (this.isOnStandby() && this.onStartChargingEvent.onStartCharging(player)) {
            this.checkAbilityPool(player, Ability.State.CHARGING);
            if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue() && this.getChargedShouts().length > 1) {
                WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[0] + "..."), (Entity)player);
            }
            AbilityUseEvent.Post post = new AbilityUseEvent.Post((LivingEntity)player, this);
            MinecraftForge.EVENT_BUS.post((Event)post);
            this.chargeTime = this.maxChargeTime;
            this.startCharging(player);
            if (this instanceof IAnimatedAbility || this instanceof IBodyOverlayAbility || this instanceof IPunchOverlayAbility) {
                WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityPacket(player.func_145782_y(), this), (Entity)player);
            }
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (Entity)player);
        }
    }

    @Override
    public void startDisable(PlayerEntity player, int ticks) {
        if (this.isCharging()) {
            this.chargeTime = this.maxChargeTime;
            this.startStandby();
        }
        super.startDisable(player, ticks);
    }

    public void setMaxChargeTime(double seconds) {
        this.chargeTime = this.maxChargeTime = (int)(seconds * 20.0);
    }

    public int getMaxChargeTime() {
        return this.maxChargeTime;
    }

    public double getChargePercentage() {
        return this.chargeTime / this.maxChargeTime * 100;
    }

    public double getInvertedChargePercentage() {
        return (1 - this.chargeTime / this.maxChargeTime) * 100;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public void setChargeTime(int time) {
        this.chargeTime = time * 20;
    }

    public void setCancelable() {
        this.isCancelable = true;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    @Override
    public void tick(PlayerEntity player) {
        super.tick(player);
        if (this.isCharging()) {
            if (this.canUse(player).isFail()) {
                this.stopCharging(player);
                return;
            }
            if (this.isCharging() && this.chargeTime > 0) {
                this.chargeTime = (int)((double)this.chargeTime - 1.0 * this.getTimeProgression());
                if (!player.field_70170_p.field_72995_K && !this.isStateForced()) {
                    this.duringChargingEvent.duringCharging(player, this.chargeTime);
                }
            } else if (this.isCharging() && this.chargeTime <= 0) {
                this.endCharging(player);
            }
        }
    }

    public void startCharging(PlayerEntity player) {
        this.setState(Ability.State.CHARGING);
    }

    public void endCharging(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isStateForced() && this.onEndChargingEvent.onEndCharging(player)) {
            if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue()) {
                WyNetwork.sendToAllTrackingAndSelf(this.getChargedShouts().length > 1 ? new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[1]) : new SAnimeScreamPacket(player.func_145782_y(), this.getChargedShouts()[0]), (Entity)player);
            }
            this.stopCharging(player);
        }
    }

    public void stopCharging(PlayerEntity player) {
        this.checkAbilityPool(player, Ability.State.COOLDOWN);
        this.setForcedState(false);
        this.chargeTime = this.maxChargeTime;
        this.startCooldown(player);
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (Entity)player);
        }
    }

    public String[] getChargedShouts() {
        String[] stringArray;
        String[] nameSplit = this.getDisplayNameOld().split(" ");
        int midPoint = (int)Math.ceil((double)nameSplit.length / 2.0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < midPoint; ++i) {
            sb.append(nameSplit[i] + " ");
        }
        String firstShout = sb.toString().replaceAll("[:-]", "");
        sb = new StringBuilder();
        for (int i = midPoint; i < nameSplit.length; ++i) {
            sb.append(nameSplit[i] + " ");
        }
        String secondShout = sb.toString().replaceAll("[:-]", "");
        if (secondShout.length() > 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = firstShout;
            stringArray = stringArray2;
            stringArray2[1] = secondShout;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = firstShout;
        }
        return stringArray;
    }

    public static interface IOnEndCharging
    extends Serializable {
        public boolean onEndCharging(PlayerEntity var1);
    }

    public static interface IOnStartCharging
    extends Serializable {
        public boolean onStartCharging(PlayerEntity var1);
    }

    public static interface IDuringCharging
    extends Serializable {
        public void duringCharging(PlayerEntity var1, int var2);
    }
}

