/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponentKey;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DisableComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PauseTickComponent;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public abstract class PassiveAbility2
implements IAbility {
    private final AbilityCore<? extends IAbility> core;
    private ITextComponent displayName;
    private ResourceLocation displayIcon;
    private ResourceLocation cachedIcon;
    private float tickRate = 1.0f;
    private float currentTick = 0.0f;
    protected final DisableComponent disableComponent = new DisableComponent(this);
    protected final CooldownComponent cooldownComponent = new CooldownComponent(this);
    protected final PauseTickComponent pauseTickComponent = new PauseTickComponent(this);
    private List<Ability.ICanUseEvent> onCanUseEvents = new ArrayList<Ability.ICanUseEvent>();
    private List<IDuringPassiveEvent> duringPassiveEvents = new ArrayList<IDuringPassiveEvent>();
    private List<IOnEquipEvent> onEquipEvents = new ArrayList<IOnEquipEvent>();
    private List<IOnRemoveEvent> onRemoveEvents = new ArrayList<IOnRemoveEvent>();
    private Map<AbilityComponentKey<?>, AbilityComponent<?>> components = new LinkedHashMap();
    protected final Random random = new Random();

    public PassiveAbility2(AbilityCore<?> core) {
        this.core = core;
        this.addComponents(this.cooldownComponent, this.disableComponent, this.pauseTickComponent);
    }

    @Override
    public void onEquip(LivingEntity entity) {
        this.onEquipEvents.forEach(event -> event.onEquip(entity, this));
    }

    @Override
    public void onRemove(LivingEntity entity) {
        this.getComponent(ModAbilityKeys.CHANGE_STATS).ifPresent(comp -> comp.removeModifiers(entity));
        this.onRemoveEvents.forEach(event -> event.onRemove(entity, this));
    }

    @Override
    public void use(LivingEntity entity) {
    }

    @Override
    public void tick(LivingEntity entity) {
        float f;
        ProtectedAreasData worldData;
        ProtectedArea area;
        this.components.values().forEach(component -> component.tick(entity));
        if (this.canUse(entity).isFail()) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K && (area = (worldData = ProtectedAreasData.get(entity.field_70170_p)).getProtectedArea(entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177956_o(), entity.func_233580_cy_().func_177952_p())) != null && !area.canUseAbility(this.getCore())) {
            return;
        }
        this.currentTick -= 1.0f;
        if (f > 0.0f) {
            return;
        }
        this.currentTick = this.tickRate;
        this.duringPassiveEvents.forEach(event -> event.duringPassive(entity));
    }

    @Override
    public AbilityUseResult canUse(LivingEntity entity) {
        if (this.disableComponent.isDisabled() || this.pauseTickComponent.isPaused() || this.cooldownComponent.isOnCooldown()) {
            return AbilityUseResult.fail(null);
        }
        Optional<AbilityUseResult> canUseResult = this.onCanUseEvents.stream().map(event -> event.canUse(entity, this)).filter(result -> result.isFail()).findFirst();
        if (canUseResult.isPresent()) {
            return canUseResult.get();
        }
        return AbilityUseResult.success();
    }

    public void addEquipEvent(IOnEquipEvent event) {
        this.onEquipEvents.add(event);
    }

    public void addRemoveEvent(IOnRemoveEvent event) {
        this.onRemoveEvents.add(event);
    }

    public void addCanUseCheck(Ability.ICanUseEvent event) {
        this.onCanUseEvents.add(event);
    }

    public void addDuringPassiveEvent(IDuringPassiveEvent event) {
        this.duringPassiveEvents.add(event);
    }

    public void setTickRate(float tickRate) {
        this.tickRate = tickRate;
        this.currentTick = tickRate;
    }

    @Override
    public AbilityCore<? extends IAbility> getCore() {
        return this.core;
    }

    public boolean hasCustomName() {
        return this.displayName != null;
    }

    public void setDisplayName(ITextComponent name) {
        this.displayName = name;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return this.displayName;
        }
        return this.getCore().getLocalizedName();
    }

    public boolean hasCustomIcon() {
        return this.displayIcon != null;
    }

    public void setDisplayIcon(@Nullable ResourceLocation texture) {
        this.displayIcon = texture;
    }

    @Override
    public ResourceLocation getIcon(LivingEntity entity) {
        if (this.core.getIcon() == null && this.cachedIcon == null) {
            ResourceLocation key = this.core.getRegistryName();
            if (key != null) {
                this.cachedIcon = new ResourceLocation(key.func_110624_b(), "textures/abilities/" + key.func_110623_a() + ".png");
            }
            return this.cachedIcon;
        }
        if (this.hasCustomIcon()) {
            return this.displayIcon;
        }
        if (this.getCore().getIcon() != null) {
            return this.getCore().getIcon();
        }
        return this.cachedIcon;
    }

    public boolean isPaused() {
        return this.pauseTickComponent.isPaused();
    }

    public void addComponents(AbilityComponent ... comps) {
        for (AbilityComponent comp2 : comps) {
            this.components.put(comp2.getKey(), comp2);
        }
        if (FMLEnvironment.dist.isClient()) {
            this.components.values().stream().forEach(c -> c.postInit(this));
        } else {
            this.components.values().stream().filter(comp -> !comp.isClientSided()).forEach(c -> c.postInit(this));
        }
    }

    @Override
    public <C extends AbilityComponent<?>> Optional<C> getComponent(AbilityComponentKey<C> key) {
        if (!this.hasComponent(key)) {
            return Optional.empty();
        }
        AbilityComponent<?> comp = this.components.get(key);
        if (comp.isClientSided() && !FMLEnvironment.dist.isClient()) {
            return Optional.empty();
        }
        return Optional.of(comp);
    }

    @Override
    public Map<AbilityComponentKey<?>, AbilityComponent<?>> getComponents() {
        return this.components;
    }

    @Override
    public boolean hasComponent(AbilityComponentKey key) {
        return this.components.containsKey(key);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        if (this.hasCustomName()) {
            nbt.func_74778_a("displayName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.getDisplayName()));
        }
        if (this.hasCustomIcon()) {
            nbt.func_74778_a("displayIcon", this.displayIcon.toString());
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        if (nbt.func_74764_b("displayName")) {
            this.setDisplayName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("displayName")));
        }
        if (nbt.func_74764_b("displayIcon")) {
            this.setDisplayIcon(new ResourceLocation(nbt.func_74779_i("displayIcon")));
        }
    }

    public boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    @Override
    public boolean isOGCD() {
        return true;
    }

    @FunctionalInterface
    public static interface IOnRemoveEvent {
        public void onRemove(LivingEntity var1, PassiveAbility2 var2);
    }

    @FunctionalInterface
    public static interface IOnEquipEvent {
        public void onEquip(LivingEntity var1, PassiveAbility2 var2);
    }

    @FunctionalInterface
    public static interface IDuringPassiveEvent {
        public void duringPassive(LivingEntity var1);
    }
}

