/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;

public abstract class RepeaterAbility2
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(200, this::onContinuityStart);
    protected final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(200, this::onRepeaterTrigger).addStopEvent(200, this::onRepeaterStop);
    protected final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::getProjectileFactory);
    private IOnTriggerShootEvent customShootLogic = null;

    public RepeaterAbility2(AbilityCore<? extends RepeaterAbility2> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.repeaterComponent, this.projectileComponent);
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.repeaterComponent.start(entity, this.getMaxTriggers(), this.getTriggerInterval());
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.repeaterComponent.stop(entity);
        }
        if (this.customShootLogic != null) {
            this.customShootLogic.customShootLogic(entity);
        } else {
            this.projectileComponent.shoot(entity, this.getProjectileSpeed(), this.getProjectileSpread());
        }
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, this.getRepeaterCooldown());
    }

    public void setCustomShootLogic(IOnTriggerShootEvent event) {
        this.customShootLogic = event;
    }

    public float getProjectileSpeed() {
        return 2.0f;
    }

    public float getProjectileSpread() {
        return 1.0f;
    }

    public abstract int getMaxTriggers();

    public abstract int getTriggerInterval();

    public abstract float getRepeaterCooldown();

    public abstract <P extends AbilityProjectileEntity> P getProjectileFactory(LivingEntity var1);

    @FunctionalInterface
    public static interface IOnTriggerShootEvent {
        public void customShootLogic(LivingEntity var1);
    }
}

