/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public abstract class SlidingAbility
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(200, this::duringContinuityEvent);

    public SlidingAbility(AbilityCore<? extends SlidingAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(200, this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_233570_aj_() && (Math.abs(entity.func_213322_ci().func_82615_a()) < 0.2 || Math.abs(entity.func_213322_ci().func_82616_c()) < 0.2)) {
            double x = MathHelper.func_151237_a((double)(entity.func_213322_ci().func_82615_a() * this.getSlidingPower()), (double)(-this.getMaxSpeed()), (double)this.getMaxSpeed());
            double z = MathHelper.func_151237_a((double)(entity.func_213322_ci().func_82616_c() * this.getSlidingPower()), (double)(-this.getMaxSpeed()), (double)this.getMaxSpeed());
            AbilityHelper.setDeltaMovement((Entity)entity, x, entity.func_213322_ci().func_82617_b(), z);
        }
    }

    public abstract double getMaxSpeed();

    public abstract double getSlidingPower();
}

