/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SChangeAbilityAltModePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AltModeComponent<E extends Enum<E>>
extends AbilityComponent<IAbility> {
    private final PriorityEventPool<IChangeModeEvent<E>> changeModeEvents = new PriorityEventPool();
    private final Class<E> modeClass;
    private final E defaultMode;
    private E currentMode;
    private boolean isModeChangeAutomatic;
    private boolean playReadyAnim = false;
    private float readyAnim = 0.0f;

    public AltModeComponent(IAbility ability, Class<E> clz, E defaultMode) {
        this(ability, clz, defaultMode, false);
    }

    public AltModeComponent(IAbility ability, Class<E> clz, E defaultMode, boolean isModeChangeAutomatic) {
        super(ModAbilityKeys.ALT_MODE, ability);
        this.modeClass = clz;
        this.defaultMode = defaultMode;
        this.currentMode = defaultMode;
        this.isModeChangeAutomatic = isModeChangeAutomatic;
    }

    public AltModeComponent<E> addChangeModeEvent(IChangeModeEvent<E> event) {
        this.changeModeEvents.addEvent(event);
        return this;
    }

    public AltModeComponent<E> addChangeModeEvent(int priority, IChangeModeEvent<E> event) {
        this.changeModeEvents.addEvent(priority, event);
        return this;
    }

    public void setMode(LivingEntity entity, Enum mode) {
        this.setMode(entity, mode, true);
    }

    public void revertToDefault(LivingEntity entity) {
        this.setMode(entity, this.defaultMode, true);
    }

    private void setMode(LivingEntity entity, E mode, boolean update) {
        this.ensureIsRegistered();
        if (!this.isMode(mode)) {
            try {
                this.changeModeEvents.dispatch(event -> event.changeMode(entity, (IAbility)this.getAbility(), mode));
                this.currentMode = mode;
                this.playReadyAnim = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        } else {
            return;
        }
        if (update && entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            WyNetwork.sendToAllTrackingAndSelf(new SChangeAbilityAltModePacket<E>((LivingEntity)player, (IAbility)super.getAbility(), this.getCurrentMode()), (Entity)player);
            if (!this.isAutomatic()) {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ALT_MODE_CHANGE, new Object[]{this.getAbility().getDisplayName().getString(), this.getCurrentMode()}), Util.field_240973_b_);
            }
        }
    }

    public void setNextInCycle(LivingEntity entity) {
        Enum[] modes = (Enum[])this.modeClass.getEnumConstants();
        Enum mode = modes[(((Enum)this.currentMode).ordinal() + 1) % modes.length];
        this.setMode(entity, mode);
    }

    public boolean isMode(E mode) {
        return ((Enum)this.currentMode).equals(mode);
    }

    public E getCurrentMode() {
        return this.currentMode;
    }

    public Class<E> getAltMode() {
        return this.modeClass;
    }

    public boolean isAutomatic() {
        return this.isModeChangeAutomatic;
    }

    private int getModesAmount() {
        Enum[] modes = (Enum[])this.modeClass.getEnumConstants();
        return modes.length;
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> component.addPostRenderEvent(100, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (this.playReadyAnim && this.readyAnim <= 0.0f) {
                this.readyAnim = 30.0f;
            } else if (this.playReadyAnim && this.readyAnim > 0.0f) {
                this.readyAnim = (float)((double)this.readyAnim - 1.75 * (double)minecraft.func_193989_ak());
                if (this.readyAnim <= 0.0f) {
                    this.playReadyAnim = false;
                } else if (this.readyAnim > 0.0f) {
                    float anim = this.readyAnim * 0.03f;
                    anim = Math.max(0.0f, anim);
                    float scale = 1.8f * EasingFunctionHelper.easeOutSine(Float.valueOf(anim));
                    float alpha = 1.0f * EasingFunctionHelper.easeOutSine(Float.valueOf(anim));
                    scale = MathHelper.func_76131_a((float)scale, (float)1.0f, (float)scale);
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)x, (double)y, 1.0);
                    matrix.func_227861_a_(12.0, 12.0, 0.0);
                    matrix.func_227862_a_(scale, scale, 1.0f);
                    matrix.func_227861_a_(-12.0, -12.0, 0.0);
                    minecraft.func_110434_K().func_110577_a(ModResources.WIDGETS);
                    RendererHelper.drawTexturedModalRect(matrix, 0.0f, 0.0f, 0.0f, 0.0f, 23.0f, 23.0f, -1.0f, 1.0f, 0.95f, 0.0f, alpha);
                    matrix.func_227865_b_();
                }
            }
        }));
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74778_a("currentMode", ((Enum)this.currentMode).toString());
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.currentMode = Enum.valueOf(this.modeClass, nbt.func_74779_i("currentMode"));
    }

    @FunctionalInterface
    public static interface IChangeModeEvent<E extends Enum<E>> {
        public void changeMode(LivingEntity var1, IAbility var2, E var3);
    }
}

