/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.commands.FGCommand;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStartCooldownPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStopCooldownPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.WyPatreon;

public class CooldownComponent
extends AbilityComponent<IAbility> {
    private static final UUID COOLDOWN_BONUS_MANAGER_UUID = UUID.fromString("99be6fa9-bcc6-4c9c-be00-ee024543015d");
    private boolean isOnCooldown;
    private float startCooldown;
    private float cooldown;
    private boolean playReadyAnim = false;
    private float cooldownReadyAnim = 10.0f;
    private final PriorityEventPool<IStartCooldownEvent> startCooldownEvents = new PriorityEventPool();
    private final PriorityEventPool<IDuringCooldownEvent> tickCooldownEvents = new PriorityEventPool();
    private final PriorityEventPool<IEndCooldownEvent> stopCooldownEvents = new PriorityEventPool();
    private final BonusManager bonusManager = new BonusManager(COOLDOWN_BONUS_MANAGER_UUID);

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float ticks) {
        return CooldownComponent.getTooltip(ticks, ticks);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float min, float max) {
        return (e, a) -> {
            float minSeconds = Math.round(min / 20.0f);
            float maxSeconds = Math.round(max / 20.0f);
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_COOLDOWN, minSeconds, maxSeconds).withUnit((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_SECONDS);
            a.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> {
                float maxBonus;
                float minBonus = Math.round((comp.getBonusManager().applyBonus(minSeconds) - minSeconds) / 20.0f);
                float diffBonus = minBonus + (maxBonus = (float)Math.round((comp.getBonusManager().applyBonus(maxSeconds) - maxSeconds) / 20.0f));
                AbilityStat.AbilityStatType bonusType = diffBonus < 0.0f ? AbilityStat.AbilityStatType.BUFF : (diffBonus > 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                statBuilder.withBonus(minBonus, maxBonus, bonusType);
            });
            return statBuilder.build().getStatDescription();
        };
    }

    public CooldownComponent(IAbility ability) {
        super(ModAbilityKeys.COOLDOWN, ability);
        this.addBonusManager(this.bonusManager);
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> {
            component.addPreRenderEvent(100, (entity, minecraft, matrix, x, y, partialTicks) -> {
                if (this.isOnCooldown()) {
                    component.setIconColor(0.6f, 0.6f, 0.6f);
                    component.setMaxValue(this.startCooldown);
                    component.setCurrentValue(this.cooldown);
                    if (ClientConfig.INSTANCE.isDisplayInPercentage()) {
                        float percentage = this.cooldown / this.startCooldown * 100.0f;
                        percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)100.0f);
                        String percentageText = String.format("%.0f", Float.valueOf(percentage)) + "%";
                        component.setDisplayText(percentageText);
                    }
                    component.setSlotColor(1.0f, 0.0f, 0.0f);
                }
            });
            component.addPostRenderEvent(100, (entity, minecraft, matrix, x, y, partialTicks) -> {
                if (this.getCooldown() == 1.0f && !this.playReadyAnim) {
                    this.playReadyAnim = true;
                    this.cooldownReadyAnim = 30.0f;
                } else if (this.playReadyAnim && this.cooldownReadyAnim > 0.0f) {
                    this.cooldownReadyAnim = (float)((double)this.cooldownReadyAnim - 1.75 * (double)minecraft.func_193989_ak());
                    if (this.cooldownReadyAnim <= 0.0f) {
                        this.playReadyAnim = false;
                    } else if (this.cooldownReadyAnim > 0.0f) {
                        float anim = this.cooldownReadyAnim * 0.03f;
                        anim = Math.max(0.0f, anim);
                        float scale = 1.8f * EasingFunctionHelper.easeOutSine(Float.valueOf(anim));
                        float alpha = 0.6f * EasingFunctionHelper.easeOutSine(Float.valueOf(anim));
                        scale = MathHelper.func_76131_a((float)scale, (float)1.0f, (float)scale);
                        matrix.func_227860_a_();
                        matrix.func_227861_a_((double)x, (double)y, 1.0);
                        matrix.func_227861_a_(12.0, 12.0, 0.0);
                        matrix.func_227862_a_(scale, scale, 1.0f);
                        matrix.func_227861_a_(-12.0, -12.0, 0.0);
                        minecraft.func_110434_K().func_110577_a(ModResources.WIDGETS);
                        RendererHelper.drawTexturedModalRect(matrix, 0.0f, 0.0f, 0.0f, 0.0f, 23.0f, 23.0f, -1.0f, 0.0f, 1.0f, 0.5f, alpha);
                        matrix.func_227865_b_();
                    }
                }
            });
        });
    }

    @Override
    protected void doTick(LivingEntity entity) {
        if (this.getAbility().hasComponent(ModAbilityKeys.DISABLE) && this.getAbility().getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
            return;
        }
        if (entity instanceof PlayerEntity && !WyPatreon.isReleaseBuild() && FGCommand.NO_COOLDOWN) {
            this.stopCooldown(entity);
            return;
        }
        this.getAbility().getComponent(ModAbilityKeys.ALT_MODE).ifPresent(component -> component.setDisabled(this.isOnCooldown()));
        if (this.isOnCooldown()) {
            if (this.cooldown > 0.0f) {
                ModifiableAttributeInstance inst = entity.func_110148_a((Attribute)ModAttributes.TIME_PROGRESSION.get());
                double timeProgression = 1.0;
                if (inst != null) {
                    timeProgression = inst.func_111126_e();
                }
                this.cooldown = (float)((double)this.cooldown - (double)super.getTpsFactor() * timeProgression);
                int loops = Math.max(1, (int)super.getTpsFactor());
                for (int i = 0; i < loops; ++i) {
                    this.tickCooldownEvents.dispatch(event -> event.duringCooldown(entity, (IAbility)this.getAbility()));
                }
            } else {
                this.stopCooldown(entity);
                return;
            }
        }
    }

    public CooldownComponent addStartEvent(IStartCooldownEvent event) {
        this.startCooldownEvents.addEvent(event);
        return this;
    }

    public CooldownComponent addStartEvent(int priority, IStartCooldownEvent event) {
        this.startCooldownEvents.addEvent(priority, event);
        return this;
    }

    public CooldownComponent addTickEvent(IDuringCooldownEvent event) {
        this.tickCooldownEvents.addEvent(event);
        return this;
    }

    public CooldownComponent addTickEvent(int priority, IDuringCooldownEvent event) {
        this.tickCooldownEvents.addEvent(priority, event);
        return this;
    }

    public CooldownComponent addEndEvent(IEndCooldownEvent event) {
        this.stopCooldownEvents.addEvent(event);
        return this;
    }

    public CooldownComponent addEndEvent(int priority, IEndCooldownEvent event) {
        this.stopCooldownEvents.addEvent(priority, event);
        return this;
    }

    public void startCooldown(LivingEntity entity, float cooldown) {
        this.ensureIsRegistered();
        if (this.isOnCooldown()) {
            return;
        }
        Optional<PoolComponent> poolComponent = this.getAbility().getComponent(ModAbilityKeys.POOL);
        cooldown = Math.max(0.0f, cooldown);
        this.startCooldown = cooldown = this.bonusManager.applyBonus(cooldown);
        this.cooldown = cooldown;
        this.isOnCooldown = true;
        if (!entity.field_70170_p.field_72995_K) {
            poolComponent.ifPresent(c -> {
                boolean ignoresCooldown = c.getPools().stream().anyMatch(pool -> pool.getFlagValue("ignoreCooldown", () -> false));
                if (!ignoresCooldown) {
                    c.startPoolInUse(entity);
                }
            });
        }
        this.startCooldownEvents.dispatch(event -> event.startCooldown(entity, (IAbility)this.getAbility()));
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStartCooldownPacket(entity, (IAbility)this.getAbility(), cooldown), (Entity)entity);
        }
    }

    public void stopCooldown(LivingEntity entity) {
        if (!this.isOnCooldown()) {
            return;
        }
        this.stopCooldownEvents.dispatch(event -> event.endCooldown(entity, (IAbility)this.getAbility()));
        this.isOnCooldown = false;
        this.startCooldown = 0.0f;
        this.cooldown = 0.0f;
        this.getAbility().getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(c -> c.resetDecoration());
        if (!entity.field_70170_p.field_72995_K) {
            this.getAbility().getComponent(ModAbilityKeys.POOL).ifPresent(c -> c.stopPoolInUse(entity));
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStopCooldownPacket(entity, (IAbility)this.getAbility()), (Entity)entity);
        }
    }

    public boolean isOnCooldown() {
        return this.isOnCooldown;
    }

    public float getStartCooldown() {
        return this.startCooldown;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public BonusManager getBonusManager() {
        return this.bonusManager;
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74776_a("cooldown", this.cooldown);
        nbt.func_74776_a("startCooldown", this.startCooldown);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.cooldown = nbt.func_74760_g("cooldown");
        this.startCooldown = nbt.func_74760_g("cooldown");
        if (this.cooldown > 0.0f) {
            this.isOnCooldown = true;
        }
    }

    @FunctionalInterface
    public static interface IEndCooldownEvent {
        public void endCooldown(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IDuringCooldownEvent {
        public void duringCooldown(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IStartCooldownEvent {
        public void startCooldown(LivingEntity var1, IAbility var2);
    }
}

