/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DisableComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PauseTickComponent;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class DamageTakenComponent
extends AbilityComponent<IAbility> {
    private final PriorityEventPool<IGetHitEvent> onAttackEvents = new PriorityEventPool();
    private final PriorityEventPool<IGetHitEvent> onHurtEvents = new PriorityEventPool();
    private final PriorityEventPool<IGetHitEvent> onDamageEvents = new PriorityEventPool();
    @Deprecated
    private DamageState state;

    public DamageTakenComponent(IAbility ability) {
        super(ModAbilityKeys.DAMAGE_TAKEN, ability);
    }

    @Deprecated
    public DamageTakenComponent(IAbility ability, IGetHitEvent event, DamageState state) {
        super(ModAbilityKeys.DAMAGE_TAKEN, ability);
        if (state == DamageState.ATTACK) {
            this.addOnAttackEvent(event);
        } else if (state == DamageState.DAMAGE) {
            this.addOnDamageEvent(event);
        } else if (state == DamageState.HURT) {
            this.addOnHurtEvent(event);
        }
        this.state = state;
    }

    @Deprecated
    public DamageState getDamageState() {
        if (this.onAttackEvents.countEventsInPool() > 0L) {
            return DamageState.ATTACK;
        }
        if (this.onHurtEvents.countEventsInPool() > 0L) {
            return DamageState.HURT;
        }
        if (this.onDamageEvents.countEventsInPool() > 0L) {
            return DamageState.DAMAGE;
        }
        return this.state;
    }

    public DamageTakenComponent addOnAttackEvent(IGetHitEvent event) {
        this.onAttackEvents.addEvent(100, event);
        return this;
    }

    public DamageTakenComponent addOnAttackEvent(int priority, IGetHitEvent event) {
        this.onAttackEvents.addEvent(priority, event);
        return this;
    }

    public DamageTakenComponent addOnHurtEvent(IGetHitEvent event) {
        this.onHurtEvents.addEvent(100, event);
        return this;
    }

    public DamageTakenComponent addOnHurtEvent(int priority, IGetHitEvent event) {
        this.onHurtEvents.addEvent(priority, event);
        return this;
    }

    public DamageTakenComponent addOnDamageEvent(IGetHitEvent event) {
        this.onDamageEvents.addEvent(100, event);
        return this;
    }

    public DamageTakenComponent addOnDamageEvent(int priority, IGetHitEvent event) {
        this.onDamageEvents.addEvent(priority, event);
        return this;
    }

    public float checkDamageTaken(LivingEntity entity, DamageSource damageSource, float damage, DamageState state) {
        super.ensureIsRegistered();
        boolean isPaused = super.getAbility().getComponent(ModAbilityKeys.PAUSE_TICK).map(PauseTickComponent::isPaused).orElse(false);
        boolean isDisabled = super.getAbility().getComponent(ModAbilityKeys.DISABLE).map(DisableComponent::isDisabled).orElse(false);
        if (isPaused || isDisabled) {
            return damage;
        }
        List<Object> events = new ArrayList();
        switch (state) {
            case ATTACK: {
                events = this.onAttackEvents.getEventsStream().collect(Collectors.toList());
                break;
            }
            case HURT: {
                events = this.onHurtEvents.getEventsStream().collect(Collectors.toList());
                break;
            }
            case DAMAGE: {
                events = this.onDamageEvents.getEventsStream().collect(Collectors.toList());
                break;
            }
        }
        for (IGetHitEvent event : events) {
            damage = event.damageCheck(entity, (IAbility)super.getAbility(), damageSource, damage);
        }
        return damage;
    }

    public static enum DamageState {
        ATTACK,
        HURT,
        DAMAGE;

    }

    @FunctionalInterface
    public static interface IGetHitEvent {
        public float damageCheck(LivingEntity var1, IAbility var2, DamageSource var3, float var4);
    }
}

